// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGE_ASYNC_READ_ALL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGE_ASYNC_READ_ALL_H

#include "google/cloud/storage/async/object_responses.h"
#include "google/cloud/storage/async/reader.h"
#include "google/cloud/storage/async/token.h"
#include "google/cloud/future.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"

namespace google {
namespace cloud {
namespace storage_experimental {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * Accumulate all the responses from @p reader.
 */
future<StatusOr<ReadPayload>> ReadAll(AsyncReader reader, AsyncToken token);

/**
 * Accumulate all the responses in @p read or return the corresponding error.
 */
future<StatusOr<ReadPayload>> ReadAll(
    StatusOr<std::pair<AsyncReader, AsyncToken>> read);

/**
 * Wait until @p pending_read is satisfied and then accumulate all the
 * responses, or return the corresponding error.
 *
 * @par Example
 * @snippet storage_async_samples.cc read-all
 *
 */
future<StatusOr<ReadPayload>> ReadAll(
    future<StatusOr<std::pair<AsyncReader, AsyncToken>>> pending_read);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storage_experimental
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGE_ASYNC_READ_ALL_H
