// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/adaptation_connection.h"
#include "google/cloud/speech/v1/adaptation_options.h"
#include "google/cloud/speech/v1/internal/adaptation_connection_impl.h"
#include "google/cloud/speech/v1/internal/adaptation_option_defaults.h"
#include "google/cloud/speech/v1/internal/adaptation_stub_factory.h"
#include "google/cloud/speech/v1/internal/adaptation_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdaptationConnection::~AdaptationConnection() = default;

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnection::CreatePhraseSet(
    google::cloud::speech::v1::CreatePhraseSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnection::GetPhraseSet(
    google::cloud::speech::v1::GetPhraseSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::speech::v1::PhraseSet>
AdaptationConnection::ListPhraseSet(
    google::cloud::speech::v1::
        ListPhraseSetRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::speech::v1::PhraseSet>>();
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationConnection::UpdatePhraseSet(
    google::cloud::speech::v1::UpdatePhraseSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AdaptationConnection::DeletePhraseSet(
    google::cloud::speech::v1::DeletePhraseSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnection::CreateCustomClass(
    google::cloud::speech::v1::CreateCustomClassRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnection::GetCustomClass(
    google::cloud::speech::v1::GetCustomClassRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::speech::v1::CustomClass>
AdaptationConnection::ListCustomClasses(
    google::cloud::speech::v1::
        ListCustomClassesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::speech::v1::CustomClass>>();
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationConnection::UpdateCustomClass(
    google::cloud::speech::v1::UpdateCustomClassRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status AdaptationConnection::DeleteCustomClass(
    google::cloud::speech::v1::DeleteCustomClassRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<AdaptationConnection> MakeAdaptationConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 AdaptationPolicyOptionList>(options, __func__);
  options = speech_v1_internal::AdaptationDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      speech_v1_internal::CreateDefaultAdaptationStub(std::move(auth), options);
  return speech_v1_internal::MakeAdaptationTracingConnection(
      std::make_shared<speech_v1_internal::AdaptationConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google
