// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_SERVICE_HEALTH_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_SERVICE_HEALTH_CONNECTION_H

#include "google/cloud/servicehealth/v1/internal/service_health_retry_traits.h"
#include "google/cloud/servicehealth/v1/service_health_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/servicehealth/v1/event_service.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicehealth_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ServiceHealthConnection`.
class ServiceHealthRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ServiceHealthRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ServiceHealthConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ServiceHealthLimitedErrorCountRetryPolicy
    : public ServiceHealthRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ServiceHealthLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ServiceHealthLimitedErrorCountRetryPolicy(
      ServiceHealthLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ServiceHealthLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ServiceHealthLimitedErrorCountRetryPolicy(
      ServiceHealthLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ServiceHealthLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ServiceHealthRetryPolicy> clone() const override {
    return std::make_unique<ServiceHealthLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ServiceHealthRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      servicehealth_v1_internal::ServiceHealthRetryTraits>
      impl_;
};

/**
 * A retry policy for `ServiceHealthConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ServiceHealthLimitedTimeRetryPolicy : public ServiceHealthRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ServiceHealthLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ServiceHealthLimitedTimeRetryPolicy(
      ServiceHealthLimitedTimeRetryPolicy&& rhs) noexcept
      : ServiceHealthLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ServiceHealthLimitedTimeRetryPolicy(
      ServiceHealthLimitedTimeRetryPolicy const& rhs) noexcept
      : ServiceHealthLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ServiceHealthRetryPolicy> clone() const override {
    return std::make_unique<ServiceHealthLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ServiceHealthRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      servicehealth_v1_internal::ServiceHealthRetryTraits>
      impl_;
};

/**
 * The `ServiceHealthConnection` object for `ServiceHealthClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ServiceHealthClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ServiceHealthClient`.
 *
 * To create a concrete instance, see `MakeServiceHealthConnection()`.
 *
 * For mocking, see `servicehealth_v1_mocks::MockServiceHealthConnection`.
 */
class ServiceHealthConnection {
 public:
  virtual ~ServiceHealthConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::servicehealth::v1::Event> ListEvents(
      google::cloud::servicehealth::v1::ListEventsRequest request);

  virtual StatusOr<google::cloud::servicehealth::v1::Event> GetEvent(
      google::cloud::servicehealth::v1::GetEventRequest const& request);

  virtual StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
  ListOrganizationEvents(
      google::cloud::servicehealth::v1::ListOrganizationEventsRequest request);

  virtual StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
  GetOrganizationEvent(
      google::cloud::servicehealth::v1::GetOrganizationEventRequest const&
          request);

  virtual StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
  ListOrganizationImpacts(
      google::cloud::servicehealth::v1::ListOrganizationImpactsRequest request);

  virtual StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
  GetOrganizationImpact(
      google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&
          request);
};

/**
 * A factory function to construct an object of type `ServiceHealthConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ServiceHealthClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ServiceHealthConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::servicehealth_v1::ServiceHealthPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ServiceHealthConnection` created by
 * this function.
 */
std::shared_ptr<ServiceHealthConnection> MakeServiceHealthConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_SERVICE_HEALTH_CONNECTION_H
