// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_SECURITY_CENTER_MANAGEMENT_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_SECURITY_CENTER_MANAGEMENT_CLIENT_H

#include "google/cloud/securitycentermanagement/v1/security_center_management_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class SecurityCenterManagementClient {
 public:
  explicit SecurityCenterManagementClient(
      std::shared_ptr<SecurityCenterManagementConnection> connection,
      Options opts = {});
  ~SecurityCenterManagementClient();

  ///@{
  /// @name Copy and move support
  SecurityCenterManagementClient(SecurityCenterManagementClient const&) =
      default;
  SecurityCenterManagementClient& operator=(
      SecurityCenterManagementClient const&) = default;
  SecurityCenterManagementClient(SecurityCenterManagementClient&&) = default;
  SecurityCenterManagementClient& operator=(SecurityCenterManagementClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(SecurityCenterManagementClient const& a,
                         SecurityCenterManagementClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(SecurityCenterManagementClient const& a,
                         SecurityCenterManagementClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
  /// given parent. This includes resident modules defined at the scope of the
  /// parent, and inherited modules, inherited from CRM ancestors (no
  /// descendants).
  ///
  /// @param parent  Required. Name of parent to list effective custom modules. specified in one
  ///  of the following formats:
  ///  * `organizations/{organization}/locations/{location}`
  ///  * `folders/{folder}/locations/{location}`
  ///  or
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L561}
  /// [google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L607}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveSecurityHealthAnalyticsCustomModule>
  ListEffectiveSecurityHealthAnalyticsCustomModules(std::string const& parent,
                                                    Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all EffectiveSecurityHealthAnalyticsCustomModules for the
  /// given parent. This includes resident modules defined at the scope of the
  /// parent, and inherited modules, inherited from CRM ancestors (no
  /// descendants).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L561}
  /// [google.cloud.securitycentermanagement.v1.ListEffectiveSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L607}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveSecurityHealthAnalyticsCustomModule>
  ListEffectiveSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
  ///
  /// @param name  Required. The full resource name of the custom module, specified in one of
  ///  the following formats:
  ///  @n
  ///  * `organizations/organization/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
  ///  * `folders/folder/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
  ///  * `projects/project/{location}/effectiveSecurityHealthAnalyticsCustomModules/{effective_security_health_analytics_custom_module}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L561}
  /// [google.cloud.securitycentermanagement.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L641}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveSecurityHealthAnalyticsCustomModule>
  GetEffectiveSecurityHealthAnalyticsCustomModule(std::string const& name,
                                                  Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EffectiveSecurityHealthAnalyticsCustomModule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveSecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L561}
  /// [google.cloud.securitycentermanagement.v1.GetEffectiveSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L641}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveSecurityHealthAnalyticsCustomModule>
  GetEffectiveSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
  /// parent. This includes resident modules defined at the scope of the parent,
  /// and inherited modules, inherited from CRM ancestors (no descendants).
  ///
  /// @param parent  Required. Name of parent organization, folder, or project in which to list
  ///  custom modules, specified in one of the following formats:
  ///  @n
  ///  * `organizations/{organization}/locations/{location}`
  ///  * `folders/{folder}/locations/{location}`
  ///  * `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L809}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListSecurityHealthAnalyticsCustomModules(std::string const& parent,
                                           Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all SecurityHealthAnalyticsCustomModules for the given
  /// parent. This includes resident modules defined at the scope of the parent,
  /// and inherited modules, inherited from CRM ancestors (no descendants).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L809}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListSecurityHealthAnalyticsCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
  /// the given CRM parent and all of the parent's CRM descendants.
  ///
  /// @param parent  Required. Name of the parent organization, folder, or project in which to
  ///  list custom modules, specified in one of the following formats:
  ///  @n
  ///  * `organizations/{organization}/locations/{location}`
  ///  * `folders/{folder}/locations/{location}`
  ///  * `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L843}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListDescendantSecurityHealthAnalyticsCustomModules(std::string const& parent,
                                                     Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all resident SecurityHealthAnalyticsCustomModules under
  /// the given CRM parent and all of the parent's CRM descendants.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListDescendantSecurityHealthAnalyticsCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L843}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListDescendantSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListDescendantSecurityHealthAnalyticsCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a SecurityHealthAnalyticsCustomModule.
  ///
  /// @param name  Required. Name of the resource
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.GetSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L877}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  GetSecurityHealthAnalyticsCustomModule(std::string const& name,
                                         Options opts = {});

  // clang-format off
  ///
  /// Retrieves a SecurityHealthAnalyticsCustomModule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.GetSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.GetSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L877}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  GetSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
  /// given CRM parent, and also creates inherited
  /// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
  /// parent. These modules are enabled by default.
  ///
  /// @param parent  Required. Name of the parent organization, folder, or project of the
  ///  module, specified in one of the following formats:
  ///  @n
  ///  * `organizations/{organization}/locations/{location}`
  ///  * `folders/{folder}/locations/{location}`
  ///  * `projects/{project}/locations/{location}`
  /// @param security_health_analytics_custom_module  Required. The resource being created
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L888}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  CreateSecurityHealthAnalyticsCustomModule(
      std::string const& parent,
      google::cloud::securitycentermanagement::v1::
          SecurityHealthAnalyticsCustomModule const&
              security_health_analytics_custom_module,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a resident SecurityHealthAnalyticsCustomModule at the scope of the
  /// given CRM parent, and also creates inherited
  /// SecurityHealthAnalyticsCustomModules for all CRM descendants of the given
  /// parent. These modules are enabled by default.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.CreateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L888}
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  CreateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          CreateSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the SecurityHealthAnalyticsCustomModule under the given name based
  /// on the given update mask. Updating the enablement state is supported on
  /// both resident and inherited modules (though resident modules cannot have an
  /// enablement state of "inherited"). Updating the display name and custom
  /// config of a module is supported on resident modules only.
  ///
  /// @param security_health_analytics_custom_module  Required. The resource being updated
  /// @param update_mask  Required. The list of fields to be updated. The only fields that can be
  ///  updated are `enablement_state` and `custom_config`. If empty or set to the
  ///  wildcard value `*`, both `enablement_state` and `custom_config` are
  ///  updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  /// [google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L918}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  UpdateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          SecurityHealthAnalyticsCustomModule const&
              security_health_analytics_custom_module,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the SecurityHealthAnalyticsCustomModule under the given name based
  /// on the given update mask. Updating the enablement state is supported on
  /// both resident and inherited modules (though resident modules cannot have an
  /// enablement state of "inherited"). Updating the display name and custom
  /// config of a module is supported on resident modules only.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SecurityHealthAnalyticsCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L661}
  /// [google.cloud.securitycentermanagement.v1.UpdateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L918}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  UpdateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          UpdateSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
  /// descendants in the CRM hierarchy. This method is only supported for
  /// resident custom modules.
  ///
  /// @param name  Required. The resource name of the SHA custom module.
  ///  @n
  ///  Its format is:
  ///  @n
  ///    * `organizations/{organization}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`.
  ///    * `folders/{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`.
  ///    * `projects/{project}/locations/{location}/securityHealthAnalyticsCustomModules/{security_health_analytics_custom_module}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L941}
  ///
  // clang-format on
  Status DeleteSecurityHealthAnalyticsCustomModule(std::string const& name,
                                                   Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified SecurityHealthAnalyticsCustomModule and all of its
  /// descendants in the CRM hierarchy. This method is only supported for
  /// resident custom modules.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.DeleteSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L941}
  ///
  // clang-format on
  Status DeleteSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          DeleteSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
  ///
  /// @param parent  Required. The relative resource name of the organization, project, or
  ///  folder. For more information about relative resource names, see [Relative
  ///  Resource
  ///  Name](https://cloud.google.com/apis/design/resource_names#relative_resource_name)
  ///  Example: `organizations/{organization_id}`.
  /// @param custom_config  Required. The custom configuration that you need to test.
  /// @param resource  Required. Resource data to simulate custom module against.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L968}
  /// [google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1173}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SimulateSecurityHealthAnalyticsCustomModuleResponse>
  SimulateSecurityHealthAnalyticsCustomModule(
      std::string const& parent,
      google::cloud::securitycentermanagement::v1::CustomConfig const&
          custom_config,
      google::cloud::securitycentermanagement::v1::
          SimulateSecurityHealthAnalyticsCustomModuleRequest::
              SimulatedResource const& resource,
      Options opts = {});

  // clang-format off
  ///
  /// Simulates a given SecurityHealthAnalyticsCustomModule and Resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L968}
  /// [google.cloud.securitycentermanagement.v1.SimulateSecurityHealthAnalyticsCustomModuleResponse]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1173}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               SimulateSecurityHealthAnalyticsCustomModuleResponse>
  SimulateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          SimulateSecurityHealthAnalyticsCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all effective Event Threat Detection custom modules for the
  /// given parent. This includes resident modules defined at the scope of the
  /// parent along with modules inherited from its ancestors.
  ///
  /// @param parent  Required. Name of parent to list effective custom modules. Its format is
  ///  `organizations/{organization}/locations/{location}`,
  ///  `folders/{folder}/locations/{location}`,
  ///  or
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1200}
  /// [google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1251}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveEventThreatDetectionCustomModule>
  ListEffectiveEventThreatDetectionCustomModules(std::string const& parent,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Lists all effective Event Threat Detection custom modules for the
  /// given parent. This includes resident modules defined at the scope of the
  /// parent along with modules inherited from its ancestors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1200}
  /// [google.cloud.securitycentermanagement.v1.ListEffectiveEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1251}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveEventThreatDetectionCustomModule>
  ListEffectiveEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEffectiveEventThreatDetectionCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets an effective ETD custom module. Retrieves the effective module at the
  /// given level. The difference between an EffectiveCustomModule and a
  /// CustomModule is that the fields for an EffectiveCustomModule are computed
  /// from ancestors if needed. For example, the enablement_state for a
  /// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
  /// enablement_state for an EffectiveCustomModule is always computed to ENABLED
  /// or DISABLED (the effective enablement_state).
  ///
  /// @param name  Required. The resource name of the ETD custom module.
  ///  @n
  ///  Its format is:
  ///  @n
  ///    * `organizations/{organization}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`.
  ///    * `folders/{folder}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`.
  ///    * `projects/{project}/locations/{location}/effectiveEventThreatDetectionCustomModules/{effective_event_threat_detection_custom_module}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1200}
  /// [google.cloud.securitycentermanagement.v1.GetEffectiveEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1284}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveEventThreatDetectionCustomModule>
  GetEffectiveEventThreatDetectionCustomModule(std::string const& name,
                                               Options opts = {});

  // clang-format off
  ///
  /// Gets an effective ETD custom module. Retrieves the effective module at the
  /// given level. The difference between an EffectiveCustomModule and a
  /// CustomModule is that the fields for an EffectiveCustomModule are computed
  /// from ancestors if needed. For example, the enablement_state for a
  /// CustomModule can be either ENABLED, DISABLED, or INHERITED. Where as the
  /// enablement_state for an EffectiveCustomModule is always computed to ENABLED
  /// or DISABLED (the effective enablement_state).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.GetEffectiveEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EffectiveEventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1200}
  /// [google.cloud.securitycentermanagement.v1.GetEffectiveEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1284}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveEventThreatDetectionCustomModule>
  GetEffectiveEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEffectiveEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all Event Threat Detection custom modules for the given
  /// Resource Manager parent. This includes resident modules defined at the
  /// scope of the parent along with modules inherited from ancestors.
  ///
  /// @param parent  Required. Name of parent to list custom modules. Its format is
  ///  `organizations/{organization}/locations/{location}`,
  ///  `folders/{folder}/locations/{location}`,
  ///  or
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1379}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListEventThreatDetectionCustomModules(std::string const& parent,
                                        Options opts = {});

  // clang-format off
  ///
  /// Lists all Event Threat Detection custom modules for the given
  /// Resource Manager parent. This includes resident modules defined at the
  /// scope of the parent along with modules inherited from ancestors.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.ListEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1379}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEventThreatDetectionCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all resident Event Threat Detection custom modules under the
  /// given Resource Manager parent and its descendants.
  ///
  /// @param parent  Required. Name of parent to list custom modules. Its format is
  ///  `organizations/{organization}/locations/{location}`,
  ///  `folders/{folder}/locations/{location}`,
  ///  or
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1419}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListDescendantEventThreatDetectionCustomModules(std::string const& parent,
                                                  Options opts = {});

  // clang-format off
  ///
  /// Lists all resident Event Threat Detection custom modules under the
  /// given Resource Manager parent and its descendants.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.ListDescendantEventThreatDetectionCustomModulesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1419}
  ///
  // clang-format on
  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListDescendantEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListDescendantEventThreatDetectionCustomModulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets an Event Threat Detection custom module.
  ///
  /// @param name  Required. The resource name of the ETD custom module.
  ///  @n
  ///  Its format is:
  ///  @n
  ///    * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  ///    * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  ///    * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.GetEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1453}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  GetEventThreatDetectionCustomModule(std::string const& name,
                                      Options opts = {});

  // clang-format off
  ///
  /// Gets an Event Threat Detection custom module.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.GetEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.GetEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1453}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  GetEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a resident Event Threat Detection custom module at the scope of the
  /// given Resource Manager parent, and also creates inherited custom modules
  /// for all descendants of the given parent. These modules are enabled by
  /// default.
  ///
  /// @param parent  Required. Name of parent for the module. Its format is
  ///  `organizations/{organization}/locations/{location}`,
  ///  `folders/{folder}/locations/{location}`,
  ///  or
  ///  `projects/{project}/locations/{location}`
  /// @param event_threat_detection_custom_module  Required. The module to create. The
  ///  event_threat_detection_custom_module.name will be ignored and server
  ///  generated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1470}
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  CreateEventThreatDetectionCustomModule(
      std::string const& parent,
      google::cloud::securitycentermanagement::v1::
          EventThreatDetectionCustomModule const&
              event_threat_detection_custom_module,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a resident Event Threat Detection custom module at the scope of the
  /// given Resource Manager parent, and also creates inherited custom modules
  /// for all descendants of the given parent. These modules are enabled by
  /// default.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.CreateEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1470}
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  CreateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          CreateEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Event Threat Detection custom module with the given name based
  /// on the given update mask. Updating the enablement state is supported for
  /// both resident and inherited modules (though resident modules cannot have an
  /// enablement state of "inherited"). Updating the display name or
  /// configuration of a module is supported for resident modules only. The type
  /// of a module cannot be changed.
  ///
  /// @param event_threat_detection_custom_module  Required. The module being updated
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  EventThreatDetectionCustomModule resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1500}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  UpdateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          EventThreatDetectionCustomModule const&
              event_threat_detection_custom_module,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the Event Threat Detection custom module with the given name based
  /// on the given update mask. Updating the enablement state is supported for
  /// both resident and inherited modules (though resident modules cannot have an
  /// enablement state of "inherited"). Updating the display name or
  /// configuration of a module is supported for resident modules only. The type
  /// of a module cannot be changed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.EventThreatDetectionCustomModule]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1303}
  /// [google.cloud.securitycentermanagement.v1.UpdateEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1500}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  UpdateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          UpdateEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified Event Threat Detection custom module and all of its
  /// descendants in the Resource Manager hierarchy. This method is only
  /// supported for resident custom modules.
  ///
  /// @param name  Required. The resource name of the ETD custom module.
  ///  @n
  ///  Its format is:
  ///  @n
  ///    * `organizations/{organization}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  ///    * `folders/{folder}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  ///    * `projects/{project}/locations/{location}/eventThreatDetectionCustomModules/{event_threat_detection_custom_module}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.DeleteEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1524}
  ///
  // clang-format on
  Status DeleteEventThreatDetectionCustomModule(std::string const& name,
                                                Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified Event Threat Detection custom module and all of its
  /// descendants in the Resource Manager hierarchy. This method is only
  /// supported for resident custom modules.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.DeleteEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.DeleteEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1524}
  ///
  // clang-format on
  Status DeleteEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          DeleteEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Validates the given Event Threat Detection custom module.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1550}
  /// [google.cloud.securitycentermanagement.v1.ValidateEventThreatDetectionCustomModuleResponse]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1572}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::
               ValidateEventThreatDetectionCustomModuleResponse>
  ValidateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          ValidateEventThreatDetectionCustomModuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets service settings for the specified Security Command Center service.
  ///
  /// @param name  Required. The Security Command Center service to retrieve.
  ///  @n
  ///  Formats:
  ///  @n
  ///    * organizations/{organization}/locations/{location}/securityCenterServices/{service}
  ///    * folders/{folder}/locations/{location}/securityCenterServices/{service}
  ///    * projects/{project}/locations/{location}/securityCenterServices/{service}
  ///  @n
  ///  The possible values for id {service} are:
  ///  @n
  ///    * container-threat-detection
  ///    * event-threat-detection
  ///    * security-health-analytics
  ///    * vm-threat-detection
  ///    * web-security-scanner
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityCenterService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.GetSecurityCenterServiceRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1609}
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  GetSecurityCenterService(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets service settings for the specified Security Command Center service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.GetSecurityCenterServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityCenterService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.GetSecurityCenterServiceRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1609}
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  GetSecurityCenterService(google::cloud::securitycentermanagement::v1::
                               GetSecurityCenterServiceRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all Security Command Center services for the given
  /// parent.
  ///
  /// @param parent  Required. The name of the parent to list Security Command Center services.
  ///  @n
  ///  Formats:
  ///  @n
  ///    * organizations/{organization}/locations/{location}
  ///    * folders/{folder}/locations/{location}
  ///    * projects/{project}/locations/{location}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityCenterService], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListSecurityCenterServicesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1638}
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  ///
  // clang-format on
  StreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>
  ListSecurityCenterServices(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns a list of all Security Command Center services for the given
  /// parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.ListSecurityCenterServicesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.securitycentermanagement.v1.SecurityCenterService], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.ListSecurityCenterServicesRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1638}
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  ///
  // clang-format on
  StreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>
  ListSecurityCenterServices(google::cloud::securitycentermanagement::v1::
                                 ListSecurityCenterServicesRequest request,
                             Options opts = {});

  // clang-format off
  ///
  /// Updates a Security Command Center service using the given update mask.
  ///
  /// @param security_center_service  Required. The updated service.
  /// @param update_mask  Required. The list of fields to be updated. Possible values:
  ///  @n
  ///    * "intended_enablement_state"
  ///    * "modules"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityCenterService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  /// [google.cloud.securitycentermanagement.v1.UpdateSecurityCenterServiceRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1675}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  UpdateSecurityCenterService(
      google::cloud::securitycentermanagement::v1::SecurityCenterService const&
          security_center_service,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Security Command Center service using the given update mask.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.securitycentermanagement.v1.UpdateSecurityCenterServiceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.securitycentermanagement.v1.SecurityCenterService])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.securitycentermanagement.v1.SecurityCenterService]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L454}
  /// [google.cloud.securitycentermanagement.v1.UpdateSecurityCenterServiceRequest]: @googleapis_reference_link{google/cloud/securitycentermanagement/v1/security_center_management.proto#L1675}
  ///
  // clang-format on
  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  UpdateSecurityCenterService(
      google::cloud::securitycentermanagement::v1::
          UpdateSecurityCenterServiceRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<SecurityCenterManagementConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_SECURITY_CENTER_MANAGEMENT_CLIENT_H
