// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_values.proto

#include "google/cloud/resourcemanager/v3/tag_values_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TagValuesConnectionIdempotencyPolicy::~TagValuesConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<TagValuesConnectionIdempotencyPolicy>
TagValuesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TagValuesConnectionIdempotencyPolicy>(*this);
}

Idempotency TagValuesConnectionIdempotencyPolicy::ListTagValues(
    google::cloud::resourcemanager::v3::ListTagValuesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::GetTagValue(
    google::cloud::resourcemanager::v3::GetTagValueRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::GetNamespacedTagValue(
    google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::CreateTagValue(
    google::cloud::resourcemanager::v3::CreateTagValueRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::UpdateTagValue(
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::DeleteTagValue(
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency TagValuesConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<TagValuesConnectionIdempotencyPolicy>
MakeDefaultTagValuesConnectionIdempotencyPolicy() {
  return std::make_unique<TagValuesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
