// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_option_defaults.h"
#include "google/cloud/privilegedaccessmanager/v1/privileged_access_manager_connection.h"
#include "google/cloud/privilegedaccessmanager/v1/privileged_access_manager_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options PrivilegedAccessManagerDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_PRIVILEGED_ACCESS_MANAGER_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_PRIVILEGED_ACCESS_MANAGER_AUTHORITY",
      "privilegedaccessmanager.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<privilegedaccessmanager_v1::
                       PrivilegedAccessManagerRetryPolicyOption>()) {
    options.set<
        privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicyOption>(
        privilegedaccessmanager_v1::
            PrivilegedAccessManagerLimitedTimeRetryPolicy(
                std::chrono::minutes(30))
                .clone());
  }
  if (!options.has<privilegedaccessmanager_v1::
                       PrivilegedAccessManagerBackoffPolicyOption>()) {
    options.set<
        privilegedaccessmanager_v1::PrivilegedAccessManagerBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<privilegedaccessmanager_v1::
                       PrivilegedAccessManagerPollingPolicyOption>()) {
    options.set<
        privilegedaccessmanager_v1::PrivilegedAccessManagerPollingPolicyOption>(
        GenericPollingPolicy<
            privilegedaccessmanager_v1::
                PrivilegedAccessManagerRetryPolicyOption::Type,
            privilegedaccessmanager_v1::
                PrivilegedAccessManagerBackoffPolicyOption::Type>(
            options
                .get<privilegedaccessmanager_v1::
                         PrivilegedAccessManagerRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          privilegedaccessmanager_v1::
              PrivilegedAccessManagerConnectionIdempotencyPolicyOption>()) {
    options.set<privilegedaccessmanager_v1::
                    PrivilegedAccessManagerConnectionIdempotencyPolicyOption>(
        privilegedaccessmanager_v1::
            MakeDefaultPrivilegedAccessManagerConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1_internal
}  // namespace cloud
}  // namespace google
