// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v2/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V2_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V2_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H

#include "google/cloud/notebooks/v2/notebook_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class NotebookServiceTracingConnection
    : public notebooks_v2::NotebookServiceConnection {
 public:
  ~NotebookServiceTracingConnection() override = default;

  explicit NotebookServiceTracingConnection(
      std::shared_ptr<notebooks_v2::NotebookServiceConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::notebooks::v2::Instance> ListInstances(
      google::cloud::notebooks::v2::ListInstancesRequest request) override;

  StatusOr<google::cloud::notebooks::v2::Instance> GetInstance(
      google::cloud::notebooks::v2::GetInstanceRequest const& request) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> CreateInstance(
      google::cloud::notebooks::v2::CreateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::CreateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> CreateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> UpdateInstance(
      google::cloud::notebooks::v2::UpdateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::UpdateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> UpdateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::OperationMetadata>>
  DeleteInstance(google::cloud::notebooks::v2::DeleteInstanceRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::DeleteInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> StartInstance(
      google::cloud::notebooks::v2::StartInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StartInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::StartInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> StartInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> StopInstance(
      google::cloud::notebooks::v2::StopInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StopInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::StopInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> StopInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> ResetInstance(
      google::cloud::notebooks::v2::ResetInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ResetInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::ResetInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> ResetInstance(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::notebooks::v2::CheckInstanceUpgradabilityResponse>
  CheckInstanceUpgradability(
      google::cloud::notebooks::v2::CheckInstanceUpgradabilityRequest const&
          request) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> UpgradeInstance(
      google::cloud::notebooks::v2::UpgradeInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpgradeInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::UpgradeInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> UpgradeInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> RollbackInstance(
      google::cloud::notebooks::v2::RollbackInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RollbackInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::RollbackInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> RollbackInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> DiagnoseInstance(
      google::cloud::notebooks::v2::DiagnoseInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DiagnoseInstance(
      NoAwaitTag,
      google::cloud::notebooks::v2::DiagnoseInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v2::Instance>> DiagnoseInstance(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<notebooks_v2::NotebookServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<notebooks_v2::NotebookServiceConnection>
MakeNotebookServiceTracingConnection(
    std::shared_ptr<notebooks_v2::NotebookServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V2_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
