// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/v1/reachability_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ReachabilityServiceConnectionIdempotencyPolicy::
    ~ReachabilityServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy>
ReachabilityServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ReachabilityServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
ReachabilityServiceConnectionIdempotencyPolicy::ListConnectivityTests(
    google::cloud::networkmanagement::v1::
        ListConnectivityTestsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ReachabilityServiceConnectionIdempotencyPolicy::GetConnectivityTest(
    google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
ReachabilityServiceConnectionIdempotencyPolicy::CreateConnectivityTest(
    google::cloud::networkmanagement::v1::
        CreateConnectivityTestRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ReachabilityServiceConnectionIdempotencyPolicy::UpdateConnectivityTest(
    google::cloud::networkmanagement::v1::
        UpdateConnectivityTestRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ReachabilityServiceConnectionIdempotencyPolicy::RerunConnectivityTest(
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ReachabilityServiceConnectionIdempotencyPolicy::DeleteConnectivityTest(
    google::cloud::networkmanagement::v1::
        DeleteConnectivityTestRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy>
MakeDefaultReachabilityServiceConnectionIdempotencyPolicy() {
  return std::make_unique<ReachabilityServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1
}  // namespace cloud
}  // namespace google
