// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/hub.proto

#include "google/cloud/networkconnectivity/v1/hub_connection.h"
#include "google/cloud/networkconnectivity/v1/hub_options.h"
#include "google/cloud/networkconnectivity/v1/internal/hub_connection_impl.h"
#include "google/cloud/networkconnectivity/v1/internal/hub_option_defaults.h"
#include "google/cloud/networkconnectivity/v1/internal/hub_stub_factory.h"
#include "google/cloud/networkconnectivity/v1/internal/hub_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

HubServiceConnection::~HubServiceConnection() = default;

StreamRange<google::cloud::networkconnectivity::v1::Hub>
HubServiceConnection::ListHubs(
    google::cloud::networkconnectivity::v1::
        ListHubsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::Hub>>();
}

StatusOr<google::cloud::networkconnectivity::v1::Hub>
HubServiceConnection::GetHub(
    google::cloud::networkconnectivity::v1::GetHubRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceConnection::CreateHub(
    google::cloud::networkconnectivity::v1::CreateHubRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Hub>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::CreateHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::CreateHubRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceConnection::CreateHub(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Hub>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceConnection::UpdateHub(
    google::cloud::networkconnectivity::v1::UpdateHubRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Hub>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::UpdateHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::UpdateHubRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceConnection::UpdateHub(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Hub>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceConnection::DeleteHub(
    google::cloud::networkconnectivity::v1::DeleteHubRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::DeleteHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::DeleteHubRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceConnection::DeleteHub(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkconnectivity::v1::Spoke>
HubServiceConnection::ListHubSpokes(
    google::cloud::networkconnectivity::v1::
        ListHubSpokesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::Spoke>>();
}

StreamRange<google::cloud::networkconnectivity::v1::Spoke>
HubServiceConnection::ListSpokes(
    google::cloud::networkconnectivity::v1::
        ListSpokesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::Spoke>>();
}

StatusOr<google::cloud::networkconnectivity::v1::Spoke>
HubServiceConnection::GetSpoke(
    google::cloud::networkconnectivity::v1::GetSpokeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceConnection::CreateSpoke(
    google::cloud::networkconnectivity::v1::CreateSpokeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Spoke>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::CreateSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::CreateSpokeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceConnection::CreateSpoke(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Spoke>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceConnection::UpdateSpoke(
    google::cloud::networkconnectivity::v1::UpdateSpokeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Spoke>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::UpdateSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::UpdateSpokeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceConnection::UpdateSpoke(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::Spoke>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
HubServiceConnection::RejectHubSpoke(
    google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::RejectHubSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
HubServiceConnection::RejectHubSpoke(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
HubServiceConnection::AcceptHubSpoke(
    google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::AcceptHubSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
HubServiceConnection::AcceptHubSpoke(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceConnection::DeleteSpoke(
    google::cloud::networkconnectivity::v1::DeleteSpokeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> HubServiceConnection::DeleteSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::DeleteSpokeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceConnection::DeleteSpoke(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::networkconnectivity::v1::RouteTable>
HubServiceConnection::GetRouteTable(
    google::cloud::networkconnectivity::v1::GetRouteTableRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::networkconnectivity::v1::Route>
HubServiceConnection::GetRoute(
    google::cloud::networkconnectivity::v1::GetRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::networkconnectivity::v1::Route>
HubServiceConnection::ListRoutes(
    google::cloud::networkconnectivity::v1::
        ListRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::Route>>();
}

StreamRange<google::cloud::networkconnectivity::v1::RouteTable>
HubServiceConnection::ListRouteTables(
    google::cloud::networkconnectivity::v1::
        ListRouteTablesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::RouteTable>>();
}

StatusOr<google::cloud::networkconnectivity::v1::Group>
HubServiceConnection::GetGroup(
    google::cloud::networkconnectivity::v1::GetGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::networkconnectivity::v1::Group>
HubServiceConnection::ListGroups(
    google::cloud::networkconnectivity::v1::
        ListGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::Group>>();
}

std::shared_ptr<HubServiceConnection> MakeHubServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 HubServicePolicyOptionList>(options, __func__);
  options = networkconnectivity_v1_internal::HubServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = networkconnectivity_v1_internal::CreateDefaultHubServiceStub(
      std::move(auth), options);
  return networkconnectivity_v1_internal::MakeHubServiceTracingConnection(
      std::make_shared<
          networkconnectivity_v1_internal::HubServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1
}  // namespace cloud
}  // namespace google
