// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/service_service.proto

#include "google/cloud/monitoring/v3/internal/service_monitoring_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/service_service.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceMonitoringServiceLogging::ServiceMonitoringServiceLogging(
    std::shared_ptr<ServiceMonitoringServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceLogging::CreateService(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::CreateServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateServiceRequest const& request) {
        return child_->CreateService(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceLogging::GetService(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::GetServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::GetServiceRequest const& request) {
        return child_->GetService(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListServicesResponse>
ServiceMonitoringServiceLogging::ListServices(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListServicesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::ListServicesRequest const& request) {
        return child_->ListServices(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::Service>
ServiceMonitoringServiceLogging::UpdateService(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::UpdateServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::UpdateServiceRequest const& request) {
        return child_->UpdateService(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status ServiceMonitoringServiceLogging::DeleteService(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::DeleteServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::DeleteServiceRequest const& request) {
        return child_->DeleteService(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceLogging::CreateServiceLevelObjective(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::CreateServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateServiceLevelObjectiveRequest const&
                 request) {
        return child_->CreateServiceLevelObjective(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceLogging::GetServiceLevelObjective(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::GetServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::GetServiceLevelObjectiveRequest const&
                 request) {
        return child_->GetServiceLevelObjective(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListServiceLevelObjectivesResponse>
ServiceMonitoringServiceLogging::ListServiceLevelObjectives(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListServiceLevelObjectivesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::ListServiceLevelObjectivesRequest const&
                 request) {
        return child_->ListServiceLevelObjectives(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ServiceLevelObjective>
ServiceMonitoringServiceLogging::UpdateServiceLevelObjective(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::UpdateServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::UpdateServiceLevelObjectiveRequest const&
                 request) {
        return child_->UpdateServiceLevelObjective(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status ServiceMonitoringServiceLogging::DeleteServiceLevelObjective(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::DeleteServiceLevelObjectiveRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::DeleteServiceLevelObjectiveRequest const&
                 request) {
        return child_->DeleteServiceLevelObjective(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
