// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MOCKS_MOCK_MANAGED_KAFKA_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MOCKS_MOCK_MANAGED_KAFKA_CONNECTION_H

#include "google/cloud/managedkafka/v1/managed_kafka_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace managedkafka_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ManagedKafkaConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ManagedKafkaClient`. To do so,
 * construct an object of type `ManagedKafkaClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockManagedKafkaConnection
    : public managedkafka_v1::ManagedKafkaConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::cloud::managedkafka::v1::Cluster>),
              ListClusters,
              (google::cloud::managedkafka::v1::ListClustersRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::managedkafka::v1::Cluster>, GetCluster,
      (google::cloud::managedkafka::v1::GetClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateCluster(Matcher<google::cloud::managedkafka::v1::CreateClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::managedkafka::v1::Cluster>>, CreateCluster,
      (google::cloud::managedkafka::v1::CreateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateCluster,
      (NoAwaitTag,
       google::cloud::managedkafka::v1::CreateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::managedkafka::v1::Cluster>>,
              CreateCluster, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateCluster(Matcher<google::cloud::managedkafka::v1::UpdateClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::managedkafka::v1::Cluster>>, UpdateCluster,
      (google::cloud::managedkafka::v1::UpdateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateCluster,
      (NoAwaitTag,
       google::cloud::managedkafka::v1::UpdateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::managedkafka::v1::Cluster>>,
              UpdateCluster, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteCluster(Matcher<google::cloud::managedkafka::v1::DeleteClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>,
      DeleteCluster,
      (google::cloud::managedkafka::v1::DeleteClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteCluster,
      (NoAwaitTag,
       google::cloud::managedkafka::v1::DeleteClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>,
      DeleteCluster, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::managedkafka::v1::Topic>), ListTopics,
              (google::cloud::managedkafka::v1::ListTopicsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::managedkafka::v1::Topic>, GetTopic,
              (google::cloud::managedkafka::v1::GetTopicRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::managedkafka::v1::Topic>, CreateTopic,
      (google::cloud::managedkafka::v1::CreateTopicRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::managedkafka::v1::Topic>, UpdateTopic,
      (google::cloud::managedkafka::v1::UpdateTopicRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteTopic,
      (google::cloud::managedkafka::v1::DeleteTopicRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>),
      ListConsumerGroups,
      (google::cloud::managedkafka::v1::ListConsumerGroupsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>,
      GetConsumerGroup,
      (google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>,
      UpdateConsumerGroup,
      (google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
           request),
      (override));

  MOCK_METHOD(
      Status, DeleteConsumerGroup,
      (google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
           request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MOCKS_MOCK_MANAGED_KAFKA_CONNECTION_H
