// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#include "google/cloud/managedkafka/v1/internal/managed_kafka_connection_impl.h"
#include "google/cloud/managedkafka/v1/internal/managed_kafka_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace managedkafka_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<managedkafka_v1::ManagedKafkaRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<managedkafka_v1::ManagedKafkaRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<managedkafka_v1::ManagedKafkaBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<managedkafka_v1::ManagedKafkaConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<managedkafka_v1::ManagedKafkaConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<managedkafka_v1::ManagedKafkaPollingPolicyOption>()
      ->clone();
}

}  // namespace

ManagedKafkaConnectionImpl::ManagedKafkaConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<managedkafka_v1_internal::ManagedKafkaStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      ManagedKafkaConnection::options())) {}

StreamRange<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaConnectionImpl::ListClusters(
    google::cloud::managedkafka::v1::ListClustersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListClusters(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::managedkafka::v1::Cluster>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<managedkafka_v1::ManagedKafkaRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::managedkafka::v1::ListClustersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::managedkafka::v1::ListClustersRequest const&
                       request) {
              return stub->ListClusters(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::managedkafka::v1::ListClustersResponse r) {
        std::vector<google::cloud::managedkafka::v1::Cluster> result(
            r.clusters().size());
        auto& messages = *r.mutable_clusters();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaConnectionImpl::GetCluster(
    google::cloud::managedkafka::v1::GetClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCluster(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::managedkafka::v1::GetClusterRequest const& request) {
        return stub_->GetCluster(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaConnectionImpl::CreateCluster(
    google::cloud::managedkafka::v1::CreateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateCluster(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::managedkafka::v1::Cluster>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::managedkafka::v1::CreateClusterRequest const&
              request) {
        return stub->AsyncCreateCluster(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::managedkafka::v1::Cluster>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ManagedKafkaConnectionImpl::CreateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::CreateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCluster(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::CreateClusterRequest const&
                 request) {
        return stub_->CreateCluster(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaConnectionImpl::CreateCluster(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::managedkafka::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::managedkafka::v1::Cluster>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateCluster",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::managedkafka::v1::Cluster>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::managedkafka::v1::Cluster>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaConnectionImpl::UpdateCluster(
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateCluster(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::managedkafka::v1::Cluster>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::managedkafka::v1::UpdateClusterRequest const&
              request) {
        return stub->AsyncUpdateCluster(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::managedkafka::v1::Cluster>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ManagedKafkaConnectionImpl::UpdateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCluster(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::UpdateClusterRequest const&
                 request) {
        return stub_->UpdateCluster(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaConnectionImpl::UpdateCluster(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::managedkafka::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::managedkafka::v1::Cluster>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateCluster",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::managedkafka::v1::Cluster>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::managedkafka::v1::Cluster>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaConnectionImpl::DeleteCluster(
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteCluster(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::managedkafka::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::managedkafka::v1::DeleteClusterRequest const&
              request) {
        return stub->AsyncDeleteCluster(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::managedkafka::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ManagedKafkaConnectionImpl::DeleteCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteCluster(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::DeleteClusterRequest const&
                 request) {
        return stub_->DeleteCluster(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaConnectionImpl::DeleteCluster(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::managedkafka::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteCluster",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::managedkafka::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::managedkafka::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::managedkafka::v1::Topic>
ManagedKafkaConnectionImpl::ListTopics(
    google::cloud::managedkafka::v1::ListTopicsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTopics(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::managedkafka::v1::Topic>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<managedkafka_v1::ManagedKafkaRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::managedkafka::v1::ListTopicsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::managedkafka::v1::ListTopicsRequest const&
                       request) {
              return stub->ListTopics(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::managedkafka::v1::ListTopicsResponse r) {
        std::vector<google::cloud::managedkafka::v1::Topic> result(
            r.topics().size());
        auto& messages = *r.mutable_topics();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaConnectionImpl::GetTopic(
    google::cloud::managedkafka::v1::GetTopicRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTopic(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::GetTopicRequest const& request) {
        return stub_->GetTopic(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaConnectionImpl::CreateTopic(
    google::cloud::managedkafka::v1::CreateTopicRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTopic(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::managedkafka::v1::CreateTopicRequest const& request) {
        return stub_->CreateTopic(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaConnectionImpl::UpdateTopic(
    google::cloud::managedkafka::v1::UpdateTopicRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTopic(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::managedkafka::v1::UpdateTopicRequest const& request) {
        return stub_->UpdateTopic(context, options, request);
      },
      *current, request, __func__);
}

Status ManagedKafkaConnectionImpl::DeleteTopic(
    google::cloud::managedkafka::v1::DeleteTopicRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTopic(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::managedkafka::v1::DeleteTopicRequest const& request) {
        return stub_->DeleteTopic(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaConnectionImpl::ListConsumerGroups(
    google::cloud::managedkafka::v1::ListConsumerGroupsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListConsumerGroups(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<managedkafka_v1::ManagedKafkaRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::managedkafka::v1::ListConsumerGroupsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::managedkafka::v1::
                       ListConsumerGroupsRequest const& request) {
              return stub->ListConsumerGroups(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::managedkafka::v1::ListConsumerGroupsResponse r) {
        std::vector<google::cloud::managedkafka::v1::ConsumerGroup> result(
            r.consumer_groups().size());
        auto& messages = *r.mutable_consumer_groups();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaConnectionImpl::GetConsumerGroup(
    google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConsumerGroup(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::GetConsumerGroupRequest const&
                 request) {
        return stub_->GetConsumerGroup(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaConnectionImpl::UpdateConsumerGroup(
    google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateConsumerGroup(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
                 request) {
        return stub_->UpdateConsumerGroup(context, options, request);
      },
      *current, request, __func__);
}

Status ManagedKafkaConnectionImpl::DeleteConsumerGroup(
    google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteConsumerGroup(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
                 request) {
        return stub_->DeleteConsumerGroup(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1_internal
}  // namespace cloud
}  // namespace google
