// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/language/v2/language_service.proto

#include "google/cloud/language/v2/internal/language_connection_impl.h"
#include "google/cloud/language/v2/internal/language_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace language_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<language_v2::LanguageServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<language_v2::LanguageServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<language_v2::LanguageServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<language_v2::LanguageServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<language_v2::LanguageServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

LanguageServiceConnectionImpl::LanguageServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<language_v2_internal::LanguageServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      LanguageServiceConnection::options())) {}

StatusOr<google::cloud::language::v2::AnalyzeSentimentResponse>
LanguageServiceConnectionImpl::AnalyzeSentiment(
    google::cloud::language::v2::AnalyzeSentimentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnalyzeSentiment(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::language::v2::AnalyzeSentimentRequest const& request) {
        return stub_->AnalyzeSentiment(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::language::v2::AnalyzeEntitiesResponse>
LanguageServiceConnectionImpl::AnalyzeEntities(
    google::cloud::language::v2::AnalyzeEntitiesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnalyzeEntities(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::language::v2::AnalyzeEntitiesRequest const& request) {
        return stub_->AnalyzeEntities(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::language::v2::ClassifyTextResponse>
LanguageServiceConnectionImpl::ClassifyText(
    google::cloud::language::v2::ClassifyTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ClassifyText(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::language::v2::ClassifyTextRequest const& request) {
        return stub_->ClassifyText(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::language::v2::ModerateTextResponse>
LanguageServiceConnectionImpl::ModerateText(
    google::cloud::language::v2::ModerateTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ModerateText(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::language::v2::ModerateTextRequest const& request) {
        return stub_->ModerateText(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::language::v2::AnnotateTextResponse>
LanguageServiceConnectionImpl::AnnotateText(
    google::cloud::language::v2::AnnotateTextRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AnnotateText(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::language::v2::AnnotateTextRequest const& request) {
        return stub_->AnnotateText(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace language_v2_internal
}  // namespace cloud
}  // namespace google
