// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/ekm_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_EKM_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_EKM_CONNECTION_IMPL_H

#include "google/cloud/kms/v1/ekm_connection.h"
#include "google/cloud/kms/v1/ekm_connection_idempotency_policy.h"
#include "google/cloud/kms/v1/ekm_options.h"
#include "google/cloud/kms/v1/internal/ekm_retry_traits.h"
#include "google/cloud/kms/v1/internal/ekm_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class EkmServiceConnectionImpl : public kms_v1::EkmServiceConnection {
 public:
  ~EkmServiceConnectionImpl() override = default;

  EkmServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<kms_v1_internal::EkmServiceStub> stub, Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::kms::v1::EkmConnection> ListEkmConnections(
      google::cloud::kms::v1::ListEkmConnectionsRequest request) override;

  StatusOr<google::cloud::kms::v1::EkmConnection> GetEkmConnection(
      google::cloud::kms::v1::GetEkmConnectionRequest const& request) override;

  StatusOr<google::cloud::kms::v1::EkmConnection> CreateEkmConnection(
      google::cloud::kms::v1::CreateEkmConnectionRequest const& request)
      override;

  StatusOr<google::cloud::kms::v1::EkmConnection> UpdateEkmConnection(
      google::cloud::kms::v1::UpdateEkmConnectionRequest const& request)
      override;

  StatusOr<google::cloud::kms::v1::EkmConfig> GetEkmConfig(
      google::cloud::kms::v1::GetEkmConfigRequest const& request) override;

  StatusOr<google::cloud::kms::v1::EkmConfig> UpdateEkmConfig(
      google::cloud::kms::v1::UpdateEkmConfigRequest const& request) override;

  StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
  VerifyConnectivity(google::cloud::kms::v1::VerifyConnectivityRequest const&
                         request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<kms_v1_internal::EkmServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_INTERNAL_EKM_CONNECTION_IMPL_H
