// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v2/functions.proto

#include "google/cloud/functions/v2/internal/function_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/functions/v2/functions.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace functions_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FunctionServiceMetadata::FunctionServiceMetadata(
    std::shared_ptr<FunctionServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::functions::v2::Function>
FunctionServiceMetadata::GetFunction(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GetFunctionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFunction(context, options, request);
}

StatusOr<google::cloud::functions::v2::ListFunctionsResponse>
FunctionServiceMetadata::ListFunctions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::ListFunctionsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFunctions(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceMetadata::AsyncCreateFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateFunction(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
FunctionServiceMetadata::CreateFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::CreateFunctionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateFunction(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceMetadata::AsyncUpdateFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("function.name=",
                           internal::UrlEncode(request.function().name())));
  return child_->AsyncUpdateFunction(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
FunctionServiceMetadata::UpdateFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::UpdateFunctionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("function.name=",
                           internal::UrlEncode(request.function().name())));
  return child_->UpdateFunction(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceMetadata::AsyncDeleteFunction(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteFunction(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
FunctionServiceMetadata::DeleteFunction(
    grpc::ClientContext& context, Options options,
    google::cloud::functions::v2::DeleteFunctionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteFunction(context, options, request);
}

StatusOr<google::cloud::functions::v2::GenerateUploadUrlResponse>
FunctionServiceMetadata::GenerateUploadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GenerateUploadUrlRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->GenerateUploadUrl(context, options, request);
}

StatusOr<google::cloud::functions::v2::GenerateDownloadUrlResponse>
FunctionServiceMetadata::GenerateDownloadUrl(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::GenerateDownloadUrlRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GenerateDownloadUrl(context, options, request);
}

StatusOr<google::cloud::functions::v2::ListRuntimesResponse>
FunctionServiceMetadata::ListRuntimes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::functions::v2::ListRuntimesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListRuntimes(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
FunctionServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> FunctionServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void FunctionServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options,
                                          std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void FunctionServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v2_internal
}  // namespace cloud
}  // namespace google
