// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/v1/internal/cloud_filestore_manager_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/filestore/v1/cloud_filestore_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace filestore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFilestoreManagerMetadata::CloudFilestoreManagerMetadata(
    std::shared_ptr<CloudFilestoreManagerStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::filestore::v1::ListInstancesResponse>
CloudFilestoreManagerMetadata::ListInstances(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::ListInstancesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListInstances(context, options, request);
}

StatusOr<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerMetadata::GetInstance(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::GetInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetInstance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncCreateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateInstance(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::CreateInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateInstance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncUpdateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("instance.name=",
                           internal::UrlEncode(request.instance().name())));
  return child_->AsyncUpdateInstance(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::UpdateInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("instance.name=",
                           internal::UrlEncode(request.instance().name())));
  return child_->UpdateInstance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncRestoreInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRestoreInstance(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::RestoreInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->RestoreInstance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncRevertInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncRevertInstance(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::RevertInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->RevertInstance(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncDeleteInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteInstance(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::DeleteInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteInstance(context, options, request);
}

StatusOr<google::cloud::filestore::v1::ListSnapshotsResponse>
CloudFilestoreManagerMetadata::ListSnapshots(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::ListSnapshotsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListSnapshots(context, options, request);
}

StatusOr<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerMetadata::GetSnapshot(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::GetSnapshotRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetSnapshot(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncCreateSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateSnapshot(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::CreateSnapshot(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateSnapshot(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncDeleteSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteSnapshot(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::DeleteSnapshot(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteSnapshot(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncUpdateSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("snapshot.name=",
                           internal::UrlEncode(request.snapshot().name())));
  return child_->AsyncUpdateSnapshot(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::UpdateSnapshot(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("snapshot.name=",
                           internal::UrlEncode(request.snapshot().name())));
  return child_->UpdateSnapshot(context, options, request);
}

StatusOr<google::cloud::filestore::v1::ListBackupsResponse>
CloudFilestoreManagerMetadata::ListBackups(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::ListBackupsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListBackups(context, options, request);
}

StatusOr<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerMetadata::GetBackup(
    grpc::ClientContext& context, Options const& options,
    google::cloud::filestore::v1::GetBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::CreateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::DeleteBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->AsyncUpdateBackup(cq, std::move(context), std::move(options),
                                   request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerMetadata::UpdateBackup(
    grpc::ClientContext& context, Options options,
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("backup.name=",
                           internal::UrlEncode(request.backup().name())));
  return child_->UpdateBackup(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
CloudFilestoreManagerMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> CloudFilestoreManagerMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void CloudFilestoreManagerMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void CloudFilestoreManagerMetadata::SetMetadata(grpc::ClientContext& context,
                                                Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore_v1_internal
}  // namespace cloud
}  // namespace google
