// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/essentialcontacts/v1/service.proto

#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace essentialcontacts_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EssentialContactsServiceTracingConnection::
    EssentialContactsServiceTracingConnection(
        std::shared_ptr<
            essentialcontacts_v1::EssentialContactsServiceConnection>
            child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceTracingConnection::CreateContact(
    google::cloud::essentialcontacts::v1::CreateContactRequest const& request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::"
      "CreateContact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateContact(request));
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceTracingConnection::UpdateContact(
    google::cloud::essentialcontacts::v1::UpdateContactRequest const& request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::"
      "UpdateContact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateContact(request));
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceTracingConnection::ListContacts(
    google::cloud::essentialcontacts::v1::ListContactsRequest request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::ListContacts");
  internal::OTelScope scope(span);
  auto sr = child_->ListContacts(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::essentialcontacts::v1::Contact>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceTracingConnection::GetContact(
    google::cloud::essentialcontacts::v1::GetContactRequest const& request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::GetContact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetContact(request));
}

Status EssentialContactsServiceTracingConnection::DeleteContact(
    google::cloud::essentialcontacts::v1::DeleteContactRequest const& request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::"
      "DeleteContact");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteContact(request));
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceTracingConnection::ComputeContacts(
    google::cloud::essentialcontacts::v1::ComputeContactsRequest request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::"
      "ComputeContacts");
  internal::OTelScope scope(span);
  auto sr = child_->ComputeContacts(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::essentialcontacts::v1::Contact>(std::move(span),
                                                     std::move(sr));
}

Status EssentialContactsServiceTracingConnection::SendTestMessage(
    google::cloud::essentialcontacts::v1::SendTestMessageRequest const&
        request) {
  auto span = internal::MakeSpan(
      "essentialcontacts_v1::EssentialContactsServiceConnection::"
      "SendTestMessage");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SendTestMessage(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<essentialcontacts_v1::EssentialContactsServiceConnection>
MakeEssentialContactsServiceTracingConnection(
    std::shared_ptr<essentialcontacts_v1::EssentialContactsServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EssentialContactsServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace essentialcontacts_v1_internal
}  // namespace cloud
}  // namespace google
