// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_TRACING_CONNECTION_H

#include "google/cloud/discoveryengine/v1/engine_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class EngineServiceTracingConnection
    : public discoveryengine_v1::EngineServiceConnection {
 public:
  ~EngineServiceTracingConnection() override = default;

  explicit EngineServiceTracingConnection(
      std::shared_ptr<discoveryengine_v1::EngineServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::discoveryengine::v1::Engine>> CreateEngine(
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateEngine(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::Engine>> CreateEngine(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
  DeleteEngine(google::cloud::discoveryengine::v1::DeleteEngineRequest const&
                   request) override;

  StatusOr<google::longrunning::Operation> DeleteEngine(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::DeleteEngineMetadata>>
  DeleteEngine(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::discoveryengine::v1::Engine> UpdateEngine(
      google::cloud::discoveryengine::v1::UpdateEngineRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Engine> GetEngine(
      google::cloud::discoveryengine::v1::GetEngineRequest const& request)
      override;

  StreamRange<google::cloud::discoveryengine::v1::Engine> ListEngines(
      google::cloud::discoveryengine::v1::ListEnginesRequest request) override;

 private:
  std::shared_ptr<discoveryengine_v1::EngineServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<discoveryengine_v1::EngineServiceConnection>
MakeEngineServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::EngineServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_TRACING_CONNECTION_H
