// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/generator.proto

#include "google/cloud/dialogflow_cx/generators_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GeneratorsClient::GeneratorsClient(
    std::shared_ptr<GeneratorsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GeneratorsClient::~GeneratorsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::ListGenerators(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListGeneratorsRequest request;
  request.set_parent(parent);
  return connection_->ListGenerators(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::ListGenerators(
    google::cloud::dialogflow::cx::v3::ListGeneratorsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGenerators(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::GetGenerator(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetGeneratorRequest request;
  request.set_name(name);
  return connection_->GetGenerator(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::GetGenerator(
    google::cloud::dialogflow::cx::v3::GetGeneratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGenerator(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::CreateGenerator(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Generator const& generator,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateGeneratorRequest request;
  request.set_parent(parent);
  *request.mutable_generator() = generator;
  return connection_->CreateGenerator(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::CreateGenerator(
    google::cloud::dialogflow::cx::v3::CreateGeneratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGenerator(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::UpdateGenerator(
    google::cloud::dialogflow::cx::v3::Generator const& generator,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest request;
  *request.mutable_generator() = generator;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGenerator(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Generator>
GeneratorsClient::UpdateGenerator(
    google::cloud::dialogflow::cx::v3::UpdateGeneratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGenerator(request);
}

Status GeneratorsClient::DeleteGenerator(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest request;
  request.set_name(name);
  return connection_->DeleteGenerator(request);
}

Status GeneratorsClient::DeleteGenerator(
    google::cloud::dialogflow::cx::v3::DeleteGeneratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGenerator(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
