// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/session_templates.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/dataproc/v1/session_templates.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SessionTemplateControllerStub {
 public:
  virtual ~SessionTemplateControllerStub() = 0;

  virtual StatusOr<google::cloud::dataproc::v1::SessionTemplate>
  CreateSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::CreateSessionTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::dataproc::v1::SessionTemplate>
  UpdateSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::UpdateSessionTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::dataproc::v1::SessionTemplate>
  GetSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::GetSessionTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::dataproc::v1::ListSessionTemplatesResponse>
  ListSessionTemplates(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::ListSessionTemplatesRequest const&
          request) = 0;

  virtual Status DeleteSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::DeleteSessionTemplateRequest const&
          request) = 0;
};

class DefaultSessionTemplateControllerStub
    : public SessionTemplateControllerStub {
 public:
  explicit DefaultSessionTemplateControllerStub(
      std::unique_ptr<
          google::cloud::dataproc::v1::SessionTemplateController::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> CreateSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::CreateSessionTemplateRequest const& request)
      override;

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> UpdateSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::UpdateSessionTemplateRequest const& request)
      override;

  StatusOr<google::cloud::dataproc::v1::SessionTemplate> GetSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::GetSessionTemplateRequest const& request)
      override;

  StatusOr<google::cloud::dataproc::v1::ListSessionTemplatesResponse>
  ListSessionTemplates(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::ListSessionTemplatesRequest const& request)
      override;

  Status DeleteSessionTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::dataproc::v1::DeleteSessionTemplateRequest const& request)
      override;

 private:
  std::unique_ptr<
      google::cloud::dataproc::v1::SessionTemplateController::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_TEMPLATE_CONTROLLER_STUB_H
