// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/internal/data_scan_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataplex/v1/datascans.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataScanServiceMetadata::DataScanServiceMetadata(
    std::shared_ptr<DataScanServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
DataScanServiceMetadata::AsyncCreateDataScan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateDataScan(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
DataScanServiceMetadata::CreateDataScan(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateDataScan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataScanServiceMetadata::AsyncUpdateDataScan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("data_scan.name=",
                           internal::UrlEncode(request.data_scan().name())));
  return child_->AsyncUpdateDataScan(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
DataScanServiceMetadata::UpdateDataScan(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("data_scan.name=",
                           internal::UrlEncode(request.data_scan().name())));
  return child_->UpdateDataScan(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataScanServiceMetadata::AsyncDeleteDataScan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteDataScan(cq, std::move(context), std::move(options),
                                     request);
}

StatusOr<google::longrunning::Operation>
DataScanServiceMetadata::DeleteDataScan(
    grpc::ClientContext& context, Options options,
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteDataScan(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceMetadata::GetDataScan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetDataScanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDataScan(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::ListDataScansResponse>
DataScanServiceMetadata::ListDataScans(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListDataScansRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDataScans(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceMetadata::RunDataScan(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::RunDataScanRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->RunDataScan(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceMetadata::GetDataScanJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GetDataScanJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDataScanJob(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::ListDataScanJobsResponse>
DataScanServiceMetadata::ListDataScanJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::ListDataScanJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDataScanJobs(context, options, request);
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceMetadata::GenerateDataQualityRules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GenerateDataQualityRules(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DataScanServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> DataScanServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void DataScanServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options,
                                          std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DataScanServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                          Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
