// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#include "google/cloud/dataplex/v1/catalog_connection.h"
#include "google/cloud/dataplex/v1/catalog_options.h"
#include "google/cloud/dataplex/v1/internal/catalog_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/catalog_option_defaults.h"
#include "google/cloud/dataplex/v1/internal/catalog_stub_factory.h"
#include "google/cloud/dataplex/v1/internal/catalog_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CatalogServiceConnection::~CatalogServiceConnection() = default;

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnection::CreateEntryType(
    google::cloud::dataplex::v1::CreateEntryTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::CreateEntryType(
    NoAwaitTag, google::cloud::dataplex::v1::CreateEntryTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnection::CreateEntryType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnection::UpdateEntryType(
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::UpdateEntryType(
    NoAwaitTag, google::cloud::dataplex::v1::UpdateEntryTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceConnection::UpdateEntryType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteEntryType(
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::DeleteEntryType(
    NoAwaitTag, google::cloud::dataplex::v1::DeleteEntryTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteEntryType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::EntryType>
CatalogServiceConnection::ListEntryTypes(
    google::cloud::dataplex::v1::
        ListEntryTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::EntryType>>();
}

StatusOr<google::cloud::dataplex::v1::EntryType>
CatalogServiceConnection::GetEntryType(
    google::cloud::dataplex::v1::GetEntryTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnection::CreateAspectType(
    google::cloud::dataplex::v1::CreateAspectTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::AspectType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::CreateAspectType(
    NoAwaitTag, google::cloud::dataplex::v1::CreateAspectTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnection::CreateAspectType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::AspectType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnection::UpdateAspectType(
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::AspectType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::UpdateAspectType(
    NoAwaitTag, google::cloud::dataplex::v1::UpdateAspectTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceConnection::UpdateAspectType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::AspectType>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteAspectType(
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::DeleteAspectType(
    NoAwaitTag, google::cloud::dataplex::v1::DeleteAspectTypeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteAspectType(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::AspectType>
CatalogServiceConnection::ListAspectTypes(
    google::cloud::dataplex::v1::
        ListAspectTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::AspectType>>();
}

StatusOr<google::cloud::dataplex::v1::AspectType>
CatalogServiceConnection::GetAspectType(
    google::cloud::dataplex::v1::GetAspectTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnection::CreateEntryGroup(
    google::cloud::dataplex::v1::CreateEntryGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::CreateEntryGroup(
    NoAwaitTag, google::cloud::dataplex::v1::CreateEntryGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnection::CreateEntryGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnection::UpdateEntryGroup(
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::UpdateEntryGroup(
    NoAwaitTag, google::cloud::dataplex::v1::UpdateEntryGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceConnection::UpdateEntryGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::EntryGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteEntryGroup(
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CatalogServiceConnection::DeleteEntryGroup(
    NoAwaitTag, google::cloud::dataplex::v1::DeleteEntryGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceConnection::DeleteEntryGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceConnection::ListEntryGroups(
    google::cloud::dataplex::v1::
        ListEntryGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::EntryGroup>>();
}

StatusOr<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceConnection::GetEntryGroup(
    google::cloud::dataplex::v1::GetEntryGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnection::CreateEntry(
    google::cloud::dataplex::v1::CreateEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnection::UpdateEntry(
    google::cloud::dataplex::v1::UpdateEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnection::DeleteEntry(
    google::cloud::dataplex::v1::DeleteEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataplex::v1::Entry>
CatalogServiceConnection::ListEntries(
    google::cloud::dataplex::v1::
        ListEntriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::Entry>>();
}

StatusOr<google::cloud::dataplex::v1::Entry> CatalogServiceConnection::GetEntry(
    google::cloud::dataplex::v1::GetEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceConnection::LookupEntry(
    google::cloud::dataplex::v1::LookupEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>
CatalogServiceConnection::SearchEntries(
    google::cloud::dataplex::v1::
        SearchEntriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>>();
}

std::shared_ptr<CatalogServiceConnection> MakeCatalogServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CatalogServicePolicyOptionList>(options,
                                                                 __func__);
  options =
      dataplex_v1_internal::CatalogServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = dataplex_v1_internal::CreateDefaultCatalogServiceStub(
      std::move(auth), options);
  return dataplex_v1_internal::MakeCatalogServiceTracingConnection(
      std::make_shared<dataplex_v1_internal::CatalogServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google
