// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_instance_templates/v1/region_instance_templates.proto

#include "google/cloud/compute/region_instance_templates/v1/region_instance_templates_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_instance_templates_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RegionInstanceTemplatesConnectionIdempotencyPolicy::
    ~RegionInstanceTemplatesConnectionIdempotencyPolicy() = default;

std::unique_ptr<RegionInstanceTemplatesConnectionIdempotencyPolicy>
RegionInstanceTemplatesConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<RegionInstanceTemplatesConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
RegionInstanceTemplatesConnectionIdempotencyPolicy::DeleteInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        DeleteInstanceTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RegionInstanceTemplatesConnectionIdempotencyPolicy::GetInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        GetInstanceTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
RegionInstanceTemplatesConnectionIdempotencyPolicy::InsertInstanceTemplate(
    google::cloud::cpp::compute::region_instance_templates::v1::
        InsertInstanceTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RegionInstanceTemplatesConnectionIdempotencyPolicy::ListRegionInstanceTemplates(
    google::cloud::cpp::compute::region_instance_templates::v1::
        ListRegionInstanceTemplatesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<RegionInstanceTemplatesConnectionIdempotencyPolicy>
MakeDefaultRegionInstanceTemplatesConnectionIdempotencyPolicy() {
  return std::make_unique<RegionInstanceTemplatesConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_instance_templates_v1
}  // namespace cloud
}  // namespace google
