// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_commitments/v1/region_commitments.proto

#include "google/cloud/compute/region_commitments/v1/internal/region_commitments_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_commitments_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionCommitmentsTracingConnection::RegionCommitmentsTracingConnection(
    std::shared_ptr<compute_region_commitments_v1::RegionCommitmentsConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::CommitmentsScopedList>>
RegionCommitmentsTracingConnection::AggregatedListRegionCommitments(
    google::cloud::cpp::compute::region_commitments::v1::
        AggregatedListRegionCommitmentsRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "AggregatedListRegionCommitments");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListRegionCommitments(std::move(request));
  return internal::MakeTracedStreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::CommitmentsScopedList>>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::Commitment>
RegionCommitmentsTracingConnection::GetCommitment(
    google::cloud::cpp::compute::region_commitments::v1::
        GetCommitmentRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "GetCommitment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetCommitment(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionCommitmentsTracingConnection::InsertCommitment(
    google::cloud::cpp::compute::region_commitments::v1::
        InsertCommitmentRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "InsertCommitment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertCommitment(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionCommitmentsTracingConnection::InsertCommitment(
    NoAwaitTag, google::cloud::cpp::compute::region_commitments::v1::
                    InsertCommitmentRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "InsertCommitment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertCommitment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionCommitmentsTracingConnection::InsertCommitment(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "InsertCommitment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertCommitment(operation));
}

StreamRange<google::cloud::cpp::compute::v1::Commitment>
RegionCommitmentsTracingConnection::ListRegionCommitments(
    google::cloud::cpp::compute::region_commitments::v1::
        ListRegionCommitmentsRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "ListRegionCommitments");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionCommitments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Commitment>(std::move(span),
                                                   std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionCommitmentsTracingConnection::UpdateCommitment(
    google::cloud::cpp::compute::region_commitments::v1::
        UpdateCommitmentRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "UpdateCommitment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateCommitment(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionCommitmentsTracingConnection::UpdateCommitment(
    NoAwaitTag, google::cloud::cpp::compute::region_commitments::v1::
                    UpdateCommitmentRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "UpdateCommitment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateCommitment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionCommitmentsTracingConnection::UpdateCommitment(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_region_commitments_v1::RegionCommitmentsConnection::"
      "UpdateCommitment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateCommitment(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_region_commitments_v1::RegionCommitmentsConnection>
MakeRegionCommitmentsTracingConnection(
    std::shared_ptr<compute_region_commitments_v1::RegionCommitmentsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<RegionCommitmentsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_commitments_v1_internal
}  // namespace cloud
}  // namespace google
