// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/https_health_checks/v1/https_health_checks.proto

#include "google/cloud/compute/https_health_checks/v1/internal/https_health_checks_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_https_health_checks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

HttpsHealthChecksRestMetadata::HttpsHealthChecksRestMetadata(
    std::shared_ptr<HttpsHealthChecksRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksRestMetadata::AsyncDeleteHttpsHealthCheck(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::https_health_checks::v1::
        DeleteHttpsHealthCheckRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteHttpsHealthCheck(cq, std::move(rest_context),
                                             std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpsHealthChecksRestMetadata::DeleteHttpsHealthCheck(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        DeleteHttpsHealthCheckRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteHttpsHealthCheck(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::HttpsHealthCheck>
HttpsHealthChecksRestMetadata::GetHttpsHealthCheck(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        GetHttpsHealthCheckRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetHttpsHealthCheck(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksRestMetadata::AsyncInsertHttpsHealthCheck(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::https_health_checks::v1::
        InsertHttpsHealthCheckRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertHttpsHealthCheck(cq, std::move(rest_context),
                                             std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpsHealthChecksRestMetadata::InsertHttpsHealthCheck(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        InsertHttpsHealthCheckRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertHttpsHealthCheck(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::HttpsHealthCheckList>
HttpsHealthChecksRestMetadata::ListHttpsHealthChecks(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        ListHttpsHealthChecksRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListHttpsHealthChecks(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksRestMetadata::AsyncPatchHttpsHealthCheck(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::https_health_checks::v1::
        PatchHttpsHealthCheckRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchHttpsHealthCheck(cq, std::move(rest_context),
                                            std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpsHealthChecksRestMetadata::PatchHttpsHealthCheck(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        PatchHttpsHealthCheckRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchHttpsHealthCheck(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksRestMetadata::AsyncUpdateHttpsHealthCheck(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::https_health_checks::v1::
        UpdateHttpsHealthCheckRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncUpdateHttpsHealthCheck(cq, std::move(rest_context),
                                             std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
HttpsHealthChecksRestMetadata::UpdateHttpsHealthCheck(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::https_health_checks::v1::
        UpdateHttpsHealthCheckRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->UpdateHttpsHealthCheck(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
HttpsHealthChecksRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> HttpsHealthChecksRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void HttpsHealthChecksRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_https_health_checks_v1_internal
}  // namespace cloud
}  // namespace google
