// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#include "google/cloud/compute/future_reservations/v1/internal/future_reservations_rest_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FutureReservationsRestLogging::FutureReservationsRestLogging(
    std::shared_ptr<FutureReservationsRestStub> child,
    TracingOptions tracing_options, std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<
    google::cloud::cpp::compute::v1::FutureReservationsAggregatedListResponse>
FutureReservationsRestLogging::AggregatedListFutureReservations(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        AggregatedListFutureReservationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 AggregatedListFutureReservationsRequest const& request) {
        return child_->AggregatedListFutureReservations(rest_context, options,
                                                        request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestLogging::AsyncCancel(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::future_reservations::v1::
                 CancelRequest const& request) {
        return child_->AsyncCancel(cq, std::move(rest_context),
                                   std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestLogging::Cancel(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 CancelRequest const& request) {
        return child_->Cancel(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestLogging::AsyncDeleteFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::future_reservations::v1::
                 DeleteFutureReservationRequest const& request) {
        return child_->AsyncDeleteFutureReservation(
            cq, std::move(rest_context), std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestLogging::DeleteFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 DeleteFutureReservationRequest const& request) {
        return child_->DeleteFutureReservation(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsRestLogging::GetFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        GetFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 GetFutureReservationRequest const& request) {
        return child_->GetFutureReservation(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestLogging::AsyncInsertFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::future_reservations::v1::
                 InsertFutureReservationRequest const& request) {
        return child_->AsyncInsertFutureReservation(
            cq, std::move(rest_context), std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestLogging::InsertFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 InsertFutureReservationRequest const& request) {
        return child_->InsertFutureReservation(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservationsListResponse>
FutureReservationsRestLogging::ListFutureReservations(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        ListFutureReservationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 ListFutureReservationsRequest const& request) {
        return child_->ListFutureReservations(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestLogging::AsyncUpdateFutureReservation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::future_reservations::v1::
                 UpdateFutureReservationRequest const& request) {
        return child_->AsyncUpdateFutureReservation(
            cq, std::move(rest_context), std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsRestLogging::UpdateFutureReservation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::future_reservations::v1::
                 UpdateFutureReservationRequest const& request) {
        return child_->UpdateFutureReservation(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsRestLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::GetOperationRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::zone_operations::v1::
                 GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> FutureReservationsRestLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::zone_operations::v1::
        DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::zone_operations::v1::
                 DeleteOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                            std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1_internal
}  // namespace cloud
}  // namespace google
