// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#include "google/cloud/compute/future_reservations/v1/future_reservations_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FutureReservationsClient::FutureReservationsClient(
    std::shared_ptr<FutureReservationsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
FutureReservationsClient::~FutureReservationsClient() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
FutureReservationsClient::AggregatedListFutureReservations(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      AggregatedListFutureReservationsRequest request;
  request.set_project(project);
  return connection_->AggregatedListFutureReservations(request);
}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
FutureReservationsClient::AggregatedListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        AggregatedListFutureReservationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListFutureReservations(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::Cancel(std::string const& project,
                                 std::string const& zone,
                                 std::string const& future_reservation,
                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::CancelRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  return connection_->Cancel(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::Cancel(NoAwaitTag, std::string const& project,
                                 std::string const& zone,
                                 std::string const& future_reservation,
                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::CancelRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  return connection_->Cancel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::Cancel(
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::Cancel(
    NoAwaitTag,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::Cancel(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::DeleteFutureReservation(
    std::string const& project, std::string const& zone,
    std::string const& future_reservation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      DeleteFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  return connection_->DeleteFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::DeleteFutureReservation(
    NoAwaitTag, std::string const& project, std::string const& zone,
    std::string const& future_reservation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      DeleteFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  return connection_->DeleteFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::DeleteFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::DeleteFutureReservation(
    NoAwaitTag,
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::DeleteFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFutureReservation(operation);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsClient::GetFutureReservation(
    std::string const& project, std::string const& zone,
    std::string const& future_reservation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      GetFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  return connection_->GetFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsClient::GetFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        GetFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFutureReservation(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::InsertFutureReservation(
    std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::FutureReservation const&
        future_reservation_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      InsertFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_future_reservation_resource() = future_reservation_resource;
  return connection_->InsertFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::InsertFutureReservation(
    NoAwaitTag, std::string const& project, std::string const& zone,
    google::cloud::cpp::compute::v1::FutureReservation const&
        future_reservation_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      InsertFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  *request.mutable_future_reservation_resource() = future_reservation_resource;
  return connection_->InsertFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::InsertFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::InsertFutureReservation(
    NoAwaitTag,
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::InsertFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertFutureReservation(operation);
}

StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsClient::ListFutureReservations(std::string const& project,
                                                 std::string const& zone,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      ListFutureReservationsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListFutureReservations(request);
}

StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsClient::ListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        ListFutureReservationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFutureReservations(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::UpdateFutureReservation(
    std::string const& project, std::string const& zone,
    std::string const& future_reservation, std::string const& update_mask,
    google::cloud::cpp::compute::v1::FutureReservation const&
        future_reservation_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      UpdateFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  request.set_update_mask(update_mask);
  *request.mutable_future_reservation_resource() = future_reservation_resource;
  return connection_->UpdateFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::UpdateFutureReservation(
    NoAwaitTag, std::string const& project, std::string const& zone,
    std::string const& future_reservation, std::string const& update_mask,
    google::cloud::cpp::compute::v1::FutureReservation const&
        future_reservation_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::future_reservations::v1::
      UpdateFutureReservationRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_future_reservation(future_reservation);
  request.set_update_mask(update_mask);
  *request.mutable_future_reservation_resource() = future_reservation_resource;
  return connection_->UpdateFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::UpdateFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFutureReservation(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsClient::UpdateFutureReservation(
    NoAwaitTag,
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFutureReservation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsClient::UpdateFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFutureReservation(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1
}  // namespace cloud
}  // namespace google
