// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/firewall_policies/v1/firewall_policies.proto

#include "google/cloud/compute/firewall_policies/v1/internal/firewall_policies_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_firewall_policies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FirewallPoliciesRestMetadata::FirewallPoliciesRestMetadata(
    std::shared_ptr<FirewallPoliciesRestStub> child,
    std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncAddAssociation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::
        AddAssociationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncAddAssociation(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::AddAssociation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        AddAssociationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AddAssociation(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncAddRule(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::AddRuleRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncAddRule(cq, std::move(rest_context), std::move(options),
                              request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::AddRule(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::AddRuleRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->AddRule(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncCloneRules(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::CloneRulesRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCloneRules(cq, std::move(rest_context),
                                 std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::CloneRules(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::CloneRulesRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->CloneRules(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncDeleteFirewallPolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::
        DeleteFirewallPolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteFirewallPolicy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::DeleteFirewallPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        DeleteFirewallPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->DeleteFirewallPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FirewallPolicy>
FirewallPoliciesRestMetadata::GetFirewallPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        GetFirewallPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetFirewallPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FirewallPolicyAssociation>
FirewallPoliciesRestMetadata::GetAssociation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        GetAssociationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetAssociation(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
FirewallPoliciesRestMetadata::GetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        GetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->GetIamPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FirewallPolicyRule>
FirewallPoliciesRestMetadata::GetRule(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::GetRuleRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetRule(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncInsertFirewallPolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::
        InsertFirewallPolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertFirewallPolicy(cq, std::move(rest_context),
                                           std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::InsertFirewallPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        InsertFirewallPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->InsertFirewallPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FirewallPolicyList>
FirewallPoliciesRestMetadata::ListFirewallPolicies(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        ListFirewallPoliciesRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListFirewallPolicies(rest_context, options, request);
}

StatusOr<
    google::cloud::cpp::compute::v1::FirewallPoliciesListAssociationsResponse>
FirewallPoliciesRestMetadata::ListAssociations(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        ListAssociationsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ListAssociations(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncMove(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::MoveRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncMove(cq, std::move(rest_context), std::move(options),
                           request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::Move(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::MoveRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->Move(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncPatchFirewallPolicy(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::
        PatchFirewallPolicyRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchFirewallPolicy(cq, std::move(rest_context),
                                          std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::PatchFirewallPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        PatchFirewallPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->PatchFirewallPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncPatchRule(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::PatchRuleRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchRule(cq, std::move(rest_context), std::move(options),
                                request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::PatchRule(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::PatchRuleRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->PatchRule(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncRemoveAssociation(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::
        RemoveAssociationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncRemoveAssociation(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::RemoveAssociation(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        RemoveAssociationRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->RemoveAssociation(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncRemoveRule(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewall_policies::v1::RemoveRuleRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncRemoveRule(cq, std::move(rest_context),
                                 std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallPoliciesRestMetadata::RemoveRule(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::RemoveRuleRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->RemoveRule(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
FirewallPoliciesRestMetadata::SetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        SetIamPolicyRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetIamPolicy(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
FirewallPoliciesRestMetadata::TestIamPermissions(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewall_policies::v1::
        TestIamPermissionsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->TestIamPermissions(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallPoliciesRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_organization_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> FirewallPoliciesRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_organization_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void FirewallPoliciesRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_firewall_policies_v1_internal
}  // namespace cloud
}  // namespace google
