// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/routine.proto

#include "google/cloud/bigquerycontrol/v2/routine_rest_connection.h"
#include "google/cloud/bigquerycontrol/v2/internal/routine_option_defaults.h"
#include "google/cloud/bigquerycontrol/v2/internal/routine_rest_connection_impl.h"
#include "google/cloud/bigquerycontrol/v2/internal/routine_rest_stub_factory.h"
#include "google/cloud/bigquerycontrol/v2/internal/routine_tracing_connection.h"
#include "google/cloud/bigquerycontrol/v2/routine_options.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/internal/rest_background_threads_impl.h"
#include "google/cloud/internal/rest_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<RoutineServiceConnection> MakeRoutineServiceConnectionRest(
    Options options) {
  internal::CheckExpectedOptions<
      CommonOptionList, RestOptionList, UnifiedCredentialsOptionList,
      rest_internal::TargetApiVersionOption, RoutineServicePolicyOptionList>(
      options, __func__);
  options = bigquerycontrol_v2_internal::RoutineServiceDefaultOptions(
      std::move(options));
  auto background = std::make_unique<
      rest_internal::AutomaticallyCreatedRestBackgroundThreads>();
  auto stub =
      bigquerycontrol_v2_internal::CreateDefaultRoutineServiceRestStub(options);
  return bigquerycontrol_v2_internal::MakeRoutineServiceTracingConnection(
      std::make_shared<
          bigquerycontrol_v2_internal::RoutineServiceRestConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
