// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/dataset.proto

#include "google/cloud/bigquerycontrol/v2/dataset_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatasetServiceClient::DatasetServiceClient(
    std::shared_ptr<DatasetServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DatasetServiceClient::~DatasetServiceClient() = default;

StatusOr<google::cloud::bigquery::v2::Dataset> DatasetServiceClient::GetDataset(
    google::cloud::bigquery::v2::GetDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDataset(request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceClient::InsertDataset(
    google::cloud::bigquery::v2::InsertDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertDataset(request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceClient::PatchDataset(
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchDataset(request);
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceClient::UpdateDataset(
    google::cloud::bigquery::v2::UpdateOrPatchDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDataset(request);
}

Status DatasetServiceClient::DeleteDataset(
    google::cloud::bigquery::v2::DeleteDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDataset(request);
}

StreamRange<google::cloud::bigquery::v2::ListFormatDataset>
DatasetServiceClient::ListDatasets(
    google::cloud::bigquery::v2::ListDatasetsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatasets(std::move(request));
}

StatusOr<google::cloud::bigquery::v2::Dataset>
DatasetServiceClient::UndeleteDataset(
    google::cloud::bigquery::v2::UndeleteDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteDataset(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2
}  // namespace cloud
}  // namespace google
