// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datapolicies/v1/datapolicy.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_INTERNAL_DATA_POLICY_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_INTERNAL_DATA_POLICY_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/datapolicies/v1/datapolicy.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_datapolicies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataPolicyServiceStub {
 public:
  virtual ~DataPolicyServiceStub() = 0;

  virtual StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  CreateDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  UpdateDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  RenameDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&
          request) = 0;

  virtual Status DeleteDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  GetDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::bigquery::datapolicies::v1::ListDataPoliciesResponse>
  ListDataPolicies(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest const&
          request) = 0;

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;
};

class DefaultDataPolicyServiceStub : public DataPolicyServiceStub {
 public:
  explicit DefaultDataPolicyServiceStub(
      std::unique_ptr<google::cloud::bigquery::datapolicies::v1::
                          DataPolicyService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  CreateDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::CreateDataPolicyRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  UpdateDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::UpdateDataPolicyRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy>
  RenameDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::RenameDataPolicyRequest const&
          request) override;

  Status DeleteDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::DeleteDataPolicyRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::datapolicies::v1::DataPolicy> GetDataPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::GetDataPolicyRequest const&
          request) override;

  StatusOr<google::cloud::bigquery::datapolicies::v1::ListDataPoliciesResponse>
  ListDataPolicies(
      grpc::ClientContext& context, Options const& options,
      google::cloud::bigquery::datapolicies::v1::ListDataPoliciesRequest const&
          request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::bigquery::datapolicies::v1::DataPolicyService::
                      StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datapolicies_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATAPOLICIES_V1_INTERNAL_DATA_POLICY_STUB_H
