// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/connection/v1/connection.proto

#include "google/cloud/bigquery/connection/v1/connection_connection.h"
#include "google/cloud/bigquery/connection/v1/connection_options.h"
#include "google/cloud/bigquery/connection/v1/internal/connection_connection_impl.h"
#include "google/cloud/bigquery/connection/v1/internal/connection_option_defaults.h"
#include "google/cloud/bigquery/connection/v1/internal/connection_stub_factory.h"
#include "google/cloud/bigquery/connection/v1/internal/connection_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_connection_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConnectionServiceConnection::~ConnectionServiceConnection() = default;

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnection::CreateConnection(
    google::cloud::bigquery::connection::v1::CreateConnectionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnection::GetConnection(
    google::cloud::bigquery::connection::v1::GetConnectionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnection::ListConnections(
    google::cloud::bigquery::connection::v1::
        ListConnectionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::connection::v1::Connection>>();
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnection::UpdateConnection(
    google::cloud::bigquery::connection::v1::UpdateConnectionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ConnectionServiceConnection::DeleteConnection(
    google::cloud::bigquery::connection::v1::DeleteConnectionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ConnectionServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ConnectionServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ConnectionServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ConnectionServiceConnection> MakeConnectionServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ConnectionServicePolicyOptionList>(options,
                                                                    __func__);
  options = bigquery_connection_v1_internal::ConnectionServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      bigquery_connection_v1_internal::CreateDefaultConnectionServiceStub(
          std::move(auth), options);
  return bigquery_connection_v1_internal::
      MakeConnectionServiceTracingConnection(
          std::make_shared<
              bigquery_connection_v1_internal::ConnectionServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_connection_v1
}  // namespace cloud
}  // namespace google
