// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#include "google/cloud/backupdr/v1/backup_dr_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace backupdr_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupDRClient::BackupDRClient(std::shared_ptr<BackupDRConnection> connection,
                               Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BackupDRClient::~BackupDRClient() = default;

StreamRange<google::cloud::backupdr::v1::ManagementServer>
BackupDRClient::ListManagementServers(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::ListManagementServersRequest request;
  request.set_parent(parent);
  return connection_->ListManagementServers(request);
}

StreamRange<google::cloud::backupdr::v1::ManagementServer>
BackupDRClient::ListManagementServers(
    google::cloud::backupdr::v1::ListManagementServersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListManagementServers(std::move(request));
}

StatusOr<google::cloud::backupdr::v1::ManagementServer>
BackupDRClient::GetManagementServer(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::GetManagementServerRequest request;
  request.set_name(name);
  return connection_->GetManagementServer(request);
}

StatusOr<google::cloud::backupdr::v1::ManagementServer>
BackupDRClient::GetManagementServer(
    google::cloud::backupdr::v1::GetManagementServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetManagementServer(request);
}

future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
BackupDRClient::CreateManagementServer(
    std::string const& parent,
    google::cloud::backupdr::v1::ManagementServer const& management_server,
    std::string const& management_server_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::CreateManagementServerRequest request;
  request.set_parent(parent);
  *request.mutable_management_server() = management_server;
  request.set_management_server_id(management_server_id);
  return connection_->CreateManagementServer(request);
}

StatusOr<google::longrunning::Operation> BackupDRClient::CreateManagementServer(
    NoAwaitTag, std::string const& parent,
    google::cloud::backupdr::v1::ManagementServer const& management_server,
    std::string const& management_server_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::CreateManagementServerRequest request;
  request.set_parent(parent);
  *request.mutable_management_server() = management_server;
  request.set_management_server_id(management_server_id);
  return connection_->CreateManagementServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
BackupDRClient::CreateManagementServer(
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementServer(request);
}

StatusOr<google::longrunning::Operation> BackupDRClient::CreateManagementServer(
    NoAwaitTag,
    google::cloud::backupdr::v1::CreateManagementServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::backupdr::v1::ManagementServer>>
BackupDRClient::CreateManagementServer(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementServer(operation);
}

future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
BackupDRClient::DeleteManagementServer(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::DeleteManagementServerRequest request;
  request.set_name(name);
  return connection_->DeleteManagementServer(request);
}

StatusOr<google::longrunning::Operation> BackupDRClient::DeleteManagementServer(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::backupdr::v1::DeleteManagementServerRequest request;
  request.set_name(name);
  return connection_->DeleteManagementServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
BackupDRClient::DeleteManagementServer(
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementServer(request);
}

StatusOr<google::longrunning::Operation> BackupDRClient::DeleteManagementServer(
    NoAwaitTag,
    google::cloud::backupdr::v1::DeleteManagementServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::backupdr::v1::OperationMetadata>>
BackupDRClient::DeleteManagementServer(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementServer(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1
}  // namespace cloud
}  // namespace google
