// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/specialist_pool_service.proto

#include "google/cloud/aiplatform/v1/internal/specialist_pool_option_defaults.h"
#include "google/cloud/aiplatform/v1/specialist_pool_connection.h"
#include "google/cloud/aiplatform/v1/specialist_pool_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options SpecialistPoolServiceDefaultOptions(std::string const& location,
                                            Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_SPECIALIST_POOL_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_SPECIALIST_POOL_SERVICE_AUTHORITY",
      absl::StrCat(location, "-", "aiplatform.googleapis.com"));
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<aiplatform_v1::SpecialistPoolServiceRetryPolicyOption>()) {
    options.set<aiplatform_v1::SpecialistPoolServiceRetryPolicyOption>(
        aiplatform_v1::SpecialistPoolServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<aiplatform_v1::SpecialistPoolServiceBackoffPolicyOption>()) {
    options.set<aiplatform_v1::SpecialistPoolServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<aiplatform_v1::SpecialistPoolServicePollingPolicyOption>()) {
    options.set<aiplatform_v1::SpecialistPoolServicePollingPolicyOption>(
        GenericPollingPolicy<
            aiplatform_v1::SpecialistPoolServiceRetryPolicyOption::Type,
            aiplatform_v1::SpecialistPoolServiceBackoffPolicyOption::Type>(
            options
                .get<aiplatform_v1::SpecialistPoolServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<aiplatform_v1::
                    SpecialistPoolServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        aiplatform_v1::SpecialistPoolServiceConnectionIdempotencyPolicyOption>(
        aiplatform_v1::
            MakeDefaultSpecialistPoolServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
