// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#include "google/cloud/aiplatform/v1/internal/feature_registry_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FeatureRegistryServiceTracingConnection::
    FeatureRegistryServiceTracingConnection(
        std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceTracingConnection::CreateFeatureGroup(
    google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateFeatureGroup(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::CreateFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeatureGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateFeatureGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceTracingConnection::CreateFeatureGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateFeatureGroup(operation));
}

StatusOr<google::cloud::aiplatform::v1::FeatureGroup>
FeatureRegistryServiceTracingConnection::GetFeatureGroup(
    google::cloud::aiplatform::v1::GetFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::GetFeatureGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFeatureGroup(request));
}

StreamRange<google::cloud::aiplatform::v1::FeatureGroup>
FeatureRegistryServiceTracingConnection::ListFeatureGroups(
    google::cloud::aiplatform::v1::ListFeatureGroupsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::ListFeatureGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListFeatureGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::FeatureGroup>(std::move(span),
                                                   std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceTracingConnection::UpdateFeatureGroup(
    google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateFeatureGroup(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::UpdateFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeatureGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateFeatureGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceTracingConnection::UpdateFeatureGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateFeatureGroup(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceTracingConnection::DeleteFeatureGroup(
    google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteFeatureGroup(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::DeleteFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeatureGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteFeatureGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceTracingConnection::DeleteFeatureGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeatureGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteFeatureGroup(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceTracingConnection::CreateFeature(
    google::cloud::aiplatform::v1::CreateFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateFeature(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::CreateFeature(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeature");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateFeature(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceTracingConnection::CreateFeature(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::CreateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateFeature(operation));
}

StatusOr<google::cloud::aiplatform::v1::Feature>
FeatureRegistryServiceTracingConnection::GetFeature(
    google::cloud::aiplatform::v1::GetFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::GetFeature");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFeature(request));
}

StreamRange<google::cloud::aiplatform::v1::Feature>
FeatureRegistryServiceTracingConnection::ListFeatures(
    google::cloud::aiplatform::v1::ListFeaturesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::ListFeatures");
  internal::OTelScope scope(span);
  auto sr = child_->ListFeatures(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::Feature>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceTracingConnection::UpdateFeature(
    google::cloud::aiplatform::v1::UpdateFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFeature(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::UpdateFeature(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeature");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateFeature(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceTracingConnection::UpdateFeature(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::UpdateFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateFeature(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceTracingConnection::DeleteFeature(
    google::cloud::aiplatform::v1::DeleteFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFeature(request));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceTracingConnection::DeleteFeature(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeature");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteFeature(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceTracingConnection::DeleteFeature(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::FeatureRegistryServiceConnection::DeleteFeature");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteFeature(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection>
MakeFeatureRegistryServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<FeatureRegistryServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
