// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/deployment_resource_pool_service.proto

#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/aiplatform/v1/deployment_resource_pool_service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeploymentResourcePoolServiceMetadata::DeploymentResourcePoolServiceMetadata(
    std::shared_ptr<DeploymentResourcePoolServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::longrunning::Operation>>
DeploymentResourcePoolServiceMetadata::AsyncCreateDeploymentResourcePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateDeploymentResourcePool(cq, std::move(context),
                                                   std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceMetadata::CreateDeploymentResourcePool(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateDeploymentResourcePool(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceMetadata::GetDeploymentResourcePool(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetDeploymentResourcePool(context, options, request);
}

StatusOr<google::cloud::aiplatform::v1::ListDeploymentResourcePoolsResponse>
DeploymentResourcePoolServiceMetadata::ListDeploymentResourcePools(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListDeploymentResourcePoolsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListDeploymentResourcePools(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeploymentResourcePoolServiceMetadata::AsyncUpdateDeploymentResourcePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("deployment_resource_pool.name=",
                           internal::UrlEncode(
                               request.deployment_resource_pool().name())));
  return child_->AsyncUpdateDeploymentResourcePool(cq, std::move(context),
                                                   std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceMetadata::UpdateDeploymentResourcePool(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("deployment_resource_pool.name=",
                           internal::UrlEncode(
                               request.deployment_resource_pool().name())));
  return child_->UpdateDeploymentResourcePool(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeploymentResourcePoolServiceMetadata::AsyncDeleteDeploymentResourcePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteDeploymentResourcePool(cq, std::move(context),
                                                   std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceMetadata::DeleteDeploymentResourcePool(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteDeploymentResourcePool(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeploymentResourcePoolServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> DeploymentResourcePoolServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void DeploymentResourcePoolServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options,
    std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DeploymentResourcePoolServiceMetadata::SetMetadata(
    grpc::ClientContext& context, Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
