// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#include "google/cloud/accessapproval/v1/internal/access_approval_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/accessapproval/v1/accessapproval.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace accessapproval_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AccessApprovalStub::~AccessApprovalStub() = default;

StatusOr<google::cloud::accessapproval::v1::ListApprovalRequestsResponse>
DefaultAccessApprovalStub::ListApprovalRequests(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::ListApprovalRequestsMessage const&
        request) {
  google::cloud::accessapproval::v1::ListApprovalRequestsResponse response;
  auto status = grpc_stub_->ListApprovalRequests(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
DefaultAccessApprovalStub::GetApprovalRequest(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::GetApprovalRequestMessage const&
        request) {
  google::cloud::accessapproval::v1::ApprovalRequest response;
  auto status = grpc_stub_->GetApprovalRequest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
DefaultAccessApprovalStub::ApproveApprovalRequest(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&
        request) {
  google::cloud::accessapproval::v1::ApprovalRequest response;
  auto status =
      grpc_stub_->ApproveApprovalRequest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
DefaultAccessApprovalStub::DismissApprovalRequest(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&
        request) {
  google::cloud::accessapproval::v1::ApprovalRequest response;
  auto status =
      grpc_stub_->DismissApprovalRequest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
DefaultAccessApprovalStub::InvalidateApprovalRequest(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::InvalidateApprovalRequestMessage const&
        request) {
  google::cloud::accessapproval::v1::ApprovalRequest response;
  auto status =
      grpc_stub_->InvalidateApprovalRequest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
DefaultAccessApprovalStub::GetAccessApprovalSettings(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::GetAccessApprovalSettingsMessage const&
        request) {
  google::cloud::accessapproval::v1::AccessApprovalSettings response;
  auto status =
      grpc_stub_->GetAccessApprovalSettings(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
DefaultAccessApprovalStub::UpdateAccessApprovalSettings(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::
        UpdateAccessApprovalSettingsMessage const& request) {
  google::cloud::accessapproval::v1::AccessApprovalSettings response;
  auto status =
      grpc_stub_->UpdateAccessApprovalSettings(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultAccessApprovalStub::DeleteAccessApprovalSettings(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::
        DeleteAccessApprovalSettingsMessage const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteAccessApprovalSettings(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::accessapproval::v1::AccessApprovalServiceAccount>
DefaultAccessApprovalStub::GetAccessApprovalServiceAccount(
    grpc::ClientContext& context, Options const&,
    google::cloud::accessapproval::v1::
        GetAccessApprovalServiceAccountMessage const& request) {
  google::cloud::accessapproval::v1::AccessApprovalServiceAccount response;
  auto status =
      grpc_stub_->GetAccessApprovalServiceAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_v1_internal
}  // namespace cloud
}  // namespace google
