// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/internal/request_id_connection_impl.h"
#include "generator/integration_tests/golden/v1/internal/request_id_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/async_retry_loop.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<golden_v1::RequestIdServiceRetryPolicy>
retry_policy(Options const& options) {
  return options.get<golden_v1::RequestIdServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy>
backoff_policy(Options const& options) {
  return options.get<golden_v1::RequestIdServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<golden_v1::RequestIdServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<golden_v1::RequestIdServiceConnectionIdempotencyPolicyOption>()->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<golden_v1::RequestIdServicePollingPolicyOption>()->clone();
}

} // namespace

RequestIdServiceConnectionImpl::RequestIdServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<golden_v1_internal::RequestIdServiceStub> stub,
    Options options)
  : background_(std::move(background)), stub_(std::move(stub)),
    options_(internal::MergeOptions(
        std::move(options),
        RequestIdServiceConnection::options())) {}

StatusOr<google::test::requestid::v1::Foo>
RequestIdServiceConnectionImpl::CreateFoo(google::test::requestid::v1::CreateFooRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  if (request_copy.request_id().empty()) {
    request_copy.set_request_id(invocation_id_generator_->MakeInvocationId());
  }
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFoo(request_copy),
      [this](grpc::ClientContext& context, Options const& options,
             google::test::requestid::v1::CreateFooRequest const& request) {
        return stub_->CreateFoo(context, options, request);
      },
      *current, request_copy, __func__);
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnectionImpl::RenameFoo(google::test::requestid::v1::RenameFooRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  if (request_copy.request_id().empty()) {
    request_copy.set_request_id(invocation_id_generator_->MakeInvocationId());
  }
  auto const idempotent =
      idempotency_policy(*current)->RenameFoo(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<google::test::requestid::v1::Foo>(
    background_->cq(), current, std::move(request_copy),
    [stub = stub_](google::cloud::CompletionQueue& cq,
                   std::shared_ptr<grpc::ClientContext> context,
                   google::cloud::internal::ImmutableOptions options,
                   google::test::requestid::v1::RenameFooRequest const& request) {
     return stub->AsyncRenameFoo(
         cq, std::move(context), std::move(options), request);
    },
    [stub = stub_](google::cloud::CompletionQueue& cq,
                   std::shared_ptr<grpc::ClientContext> context,
                   google::cloud::internal::ImmutableOptions options,
                   google::longrunning::GetOperationRequest const& request) {
     return stub->AsyncGetOperation(
         cq, std::move(context), std::move(options), request);
    },
    [stub = stub_](google::cloud::CompletionQueue& cq,
                   std::shared_ptr<grpc::ClientContext> context,
                   google::cloud::internal::ImmutableOptions options,
                   google::longrunning::CancelOperationRequest const& request) {
     return stub->AsyncCancelOperation(
         cq, std::move(context), std::move(options), request);
    },
    &google::cloud::internal::ExtractLongRunningResultResponse<google::test::requestid::v1::Foo>,
    retry_policy(*current), backoff_policy(*current), idempotent,
    polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
RequestIdServiceConnectionImpl::RenameFoo(
      NoAwaitTag, google::test::requestid::v1::RenameFooRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RenameFoo(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::test::requestid::v1::RenameFooRequest const& request) {
        return stub_->RenameFoo(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnectionImpl::RenameFoo(
      google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata().Is<typename google::test::requestid::v1::RenameFooMetadata>()) {
    return make_ready_future<StatusOr<google::test::requestid::v1::Foo>>(
        internal::InvalidArgumentError("operation does not correspond to RenameFoo",
                                       GCP_ERROR_INFO().WithMetadata("operation", operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<google::test::requestid::v1::Foo>(
    background_->cq(), current, operation,
    [stub = stub_](google::cloud::CompletionQueue& cq,
                   std::shared_ptr<grpc::ClientContext> context,
                   google::cloud::internal::ImmutableOptions options,
                   google::longrunning::GetOperationRequest const& request) {
     return stub->AsyncGetOperation(
         cq, std::move(context), std::move(options), request);
    },
    [stub = stub_](google::cloud::CompletionQueue& cq,
                   std::shared_ptr<grpc::ClientContext> context,
                   google::cloud::internal::ImmutableOptions options,
                   google::longrunning::CancelOperationRequest const& request) {
     return stub->AsyncCancelOperation(
         cq, std::move(context), std::move(options), request);
    },
    &google::cloud::internal::ExtractLongRunningResultResponse<google::test::requestid::v1::Foo>,
    polling_policy(*current), __func__);
}

StreamRange<google::test::requestid::v1::Foo>
RequestIdServiceConnectionImpl::ListFoos(google::test::requestid::v1::ListFoosRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFoos(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<google::test::requestid::v1::Foo>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<golden_v1::RequestIdServiceRetryPolicy>(retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::test::requestid::v1::ListFoosRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::test::requestid::v1::ListFoosRequest const& request) {
              return stub->ListFoos(context, options, request);
            },
            options, r, function_name);
      },
      [](google::test::requestid::v1::ListFoosResponse r) {
        std::vector<google::test::requestid::v1::Foo> result(r.foos().size());
        auto& messages = *r.mutable_foos();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceConnectionImpl::AsyncCreateFoo(google::test::requestid::v1::CreateFooRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  if (request_copy.request_id().empty()) {
    request_copy.set_request_id(invocation_id_generator_->MakeInvocationId());
  }
  auto const idempotent =
      idempotency_policy(*current)->CreateFoo(request_copy);
  auto retry = retry_policy(*current);
  auto backoff = backoff_policy(*current);
  return google::cloud::internal::AsyncRetryLoop(
      std::move(retry), std::move(backoff), idempotent, background_->cq(),
      [stub = stub_](CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::test::requestid::v1::CreateFooRequest const& request) {
        return stub->AsyncCreateFoo(
            cq, std::move(context), std::move(options), request);
      },
      std::move(current), std::move(request_copy), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
