/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef TABWIDGET_H
#define TABWIDGET_H

#include "tabwidgetitem.h"
#include <QTabWidget>
#include <QPushButton>
#include <QScopedPointer>

class Action;

class TabWidget: public QTabWidget
{
    Q_OBJECT
public:
    TabWidget(QWidget *parent = 0);
    ~TabWidget();

    void showAddButton(bool show = true);

public slots:
    void addTab();
    void addTab(const Action action);
    void delTab(int i);
    void delTabs();

private:
    bool m_add_button_shown;
    QScopedPointer <QPushButton> m_btn_add;
};

#endif // TABWIDGET_H
