/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#include "tabwidget.h"
#include "action.h"

TabWidget::TabWidget(QWidget *parent):
    QTabWidget(parent),
    m_add_button_shown(true),
    m_btn_add(new QPushButton(this))
{

    m_btn_add->setIcon(QIcon(":/img/add.png"));
    m_btn_add->adjustSize();
    m_btn_add->setFlat(true);
    setCornerWidget(m_btn_add.data(), Qt::TopLeftCorner);
    setTabsClosable(true);

    addTab();

    connect(m_btn_add.data(), SIGNAL(clicked()), this, SLOT(addTab()));
    connect(this, SIGNAL(tabCloseRequested(int)), this, SLOT(delTab(int)));
}

TabWidget::~TabWidget()
{
}

void TabWidget::showAddButton(bool show)
{
    if (show == m_add_button_shown)
        return;

    // update the widget content - add button visibility changed
    m_add_button_shown = show;
    m_btn_add->setVisible(show);
}


void TabWidget::addTab()
{
    QTabWidget::addTab(new TabWidgetItem, QString("Act. %1").arg(count() + 1));
    setCurrentIndex(count() - 1);
}

void TabWidget::addTab(Action action)
{
    // add new tab with filled content
    addTab();
    TabWidgetItem *item = static_cast <TabWidgetItem *> (widget(count() - 1));
    item->setLevel(action.level());
    item->setText(action.attr());
    item->setType(action.type());
}

void TabWidget::delTab(int i)
{
    // do not remove the only tab
    if (count() == 1)
    {
        static_cast <TabWidgetItem *> (widget(0))->clear();
        return;
    }

    // free tab widget item and delete the tab
    delete widget(i);

    // update tabs captions
    for (int j = i; j < count(); j++)
        setTabText(j, QString("Act. %1").arg(j + 1));
}

void TabWidget::delTabs()
{
    clear();
}
