/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef SYSTEMTRAYICON_H
#define SYSTEMTRAYICON_H

#include <QSystemTrayIcon>
#include <QTimer>

class SystemTrayIcon: public QSystemTrayIcon
{
    Q_OBJECT

public:
    explicit SystemTrayIcon(QObject *parent = 0);
    ~SystemTrayIcon();

public slots:
    void setTooltipBalloon(bool s = true);

private slots:
    void trayClicked(QSystemTrayIcon::ActivationReason reason);

signals:
    void clicked();
    void doubleClicked();
    void hint();

protected:
    virtual bool event(QEvent *ev);

private:
    bool m_balloon;
};

class BatteryMeterTrayIcon: public SystemTrayIcon
{
    Q_OBJECT

public:
    explicit BatteryMeterTrayIcon(QObject *parent = 0);
    ~BatteryMeterTrayIcon();

public slots:
    void setPercentage(int perc);
    void setAnimate(bool anim = true);

private slots:
    void animate();

private:
    int m_act_icon;
    QTimer m_animator;
};

#endif // SYSTEMTRAYICON_H
