/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#include "systemtrayicon.h"
#include <QEvent>
#include <iostream>

SystemTrayIcon::SystemTrayIcon(QObject *parent):
    QSystemTrayIcon(parent),
    m_balloon(true)
{
    connect(this, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(trayClicked(QSystemTrayIcon::ActivationReason)));
}

SystemTrayIcon::~SystemTrayIcon()
{
}

void SystemTrayIcon::setTooltipBalloon(bool s)
{
    m_balloon = s;
}

void SystemTrayIcon::trayClicked(QSystemTrayIcon::ActivationReason reason)
{
    if (reason == QSystemTrayIcon::Trigger)
        emit clicked();
    else if (reason == QSystemTrayIcon::DoubleClick)
        emit doubleClicked();
}

bool SystemTrayIcon::event(QEvent *ev)
{
    if (ev->type() != QEvent::ToolTip || m_balloon)
        return QSystemTrayIcon::event(ev);

    emit hint();
    ev->accept();
    return true;
}

//------------------------------------------------------------------------------

const int ANIMATOR_INTERVAL = 800;

BatteryMeterTrayIcon::BatteryMeterTrayIcon(QObject *parent):
    SystemTrayIcon(parent),
    m_act_icon(-1)
{
    m_animator.setInterval(ANIMATOR_INTERVAL);
    connect(&m_animator, SIGNAL(timeout()), this, SLOT(animate()));
}

BatteryMeterTrayIcon::~BatteryMeterTrayIcon()
{
}

void BatteryMeterTrayIcon::setPercentage(int perc)
{
    if (perc < 0 && perc > 100)
        return;

    const int index = static_cast <int> (perc / 16.6 - 0.1);
    if (m_act_icon != index)
    {
        m_act_icon = index;
        QString pic_name = ":/img/battery_" + QString("%1").arg(m_act_icon) + ".png";

        // update icon
        setIcon(QIcon(pic_name));
    }
}

void BatteryMeterTrayIcon::setAnimate(bool anim)
{
    if (m_animator.isActive() == anim)
        return;

    if (anim)
    {
        animate();
        m_animator.start();
    }
    else
    {
        m_animator.stop();
    }
}

void BatteryMeterTrayIcon::animate()
{
    m_act_icon++;
    m_act_icon %= 6;
    QString pic_name = ":/img/battery_" + QString("%1").arg(m_act_icon) + ".png";
    setIcon(QIcon(pic_name));
}
