/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#include "graphdialog.h"

GraphDialog::GraphDialog(QWidget *parent) :
	QDialog(parent)
{
	setupUi(this);

	m_graph = new Graph(m_scroll_area);
	m_scroll_area->setWidget(m_graph);
	m_graph->load();

	connect(m_btn_refresh, SIGNAL(clicked()), m_graph, SLOT(load()));
}

GraphDialog::~GraphDialog()
{
	delete m_graph;
}
