/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef DATAMINER_H
#define DATAMINER_H

#include <QString>
#include <QVector>
#include <QDateTime>

class Data
{
public:
	Data();
	explicit Data(QDateTime date, int level, bool ac);
	~Data();

	void setDateTime(QDateTime date);
	void setLevel(int level);
	void setAc(bool ac);

	QDateTime dateTime() const;
	int level() const;
	bool ac() const;

private:
	QDateTime m_date_time;
	int m_level;
	bool m_ac;
};

class DataMiner
{
public:
	DataMiner();
	virtual ~DataMiner();

	virtual void load(const QString &filename) = 0;
	virtual QVector <Data> data() const = 0;

protected:
	QVector <Data> m_data;
};

#endif // DATAMINER_H
