/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.dialogs;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.palette.command.CategoryEditCommand;
import org.eclipse.wb.internal.core.xml.editor.palette.command.Command;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.CategoryAbstractDialog;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;

public final class CategoryEditDialog
extends CategoryAbstractDialog {
    private final CategoryInfo m_category;

    public CategoryEditDialog(Shell parentShell, CategoryInfo category) {
        super(parentShell, Messages.CategoryEditDialog_title, Messages.CategoryEditDialog_description);
        this.m_category = category;
    }

    @Override
    protected void createControls(Composite container) {
        super.createControls(container);
        this.m_idField.setText(this.m_category.getId());
        this.m_nameField.setText(this.m_category.getName());
        this.m_descriptionField.setText(this.m_category.getDescription());
        this.m_stateField.setSelection(0, this.m_category.isVisible());
        this.m_stateField.setSelection(1, this.m_category.isOpen());
    }

    @Override
    protected Command createCommand() {
        String name = this.m_nameField.getText();
        String description = this.m_descriptionField.getText();
        boolean hidden = this.m_stateField.isSelected(0);
        boolean open = this.m_stateField.isSelected(1);
        return new CategoryEditCommand(this.m_category.getId(), name, description, hidden, open);
    }
}

