"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDragImportEdits = void 0;
const shared_1 = require("@vue/shared");
const path = require("path-browserify");
const vue_extract_file_1 = require("../plugins/vue-extract-file");
const types_1 = require("../types");
function getDragImportEdits(ts, ctx, uri, importUri, casing) {
    let baseName = importUri.substring(importUri.lastIndexOf('/') + 1);
    baseName = baseName.substring(0, baseName.lastIndexOf('.'));
    const newName = (0, shared_1.capitalize)((0, shared_1.camelize)(baseName));
    const document = ctx.getTextDocument(uri);
    const [vueFile] = ctx.documents.getVirtualFileByUri(document.uri);
    const { sfc } = vueFile;
    const script = sfc.scriptSetup ?? sfc.script;
    if (!sfc.template || !script)
        return;
    const lastImportNode = (0, vue_extract_file_1.getLastImportNode)(ts, script.ast);
    const edits = [
        {
            range: lastImportNode ? {
                start: document.positionAt(script.startTagEnd + lastImportNode.end),
                end: document.positionAt(script.startTagEnd + lastImportNode.end),
            } : {
                start: document.positionAt(script.startTagEnd),
                end: document.positionAt(script.startTagEnd),
            },
            newText: `\nimport ${newName} from './${path.relative(path.dirname(uri), importUri) || importUri.substring(importUri.lastIndexOf('/') + 1)}'`,
        },
    ];
    if (sfc.script) {
        const edit = (0, vue_extract_file_1.createAddComponentToOptionEdit)(ts, sfc.script.ast, newName);
        if (edit) {
            edits.push({
                range: {
                    start: document.positionAt(sfc.script.startTagEnd + edit.range.start),
                    end: document.positionAt(sfc.script.startTagEnd + edit.range.end),
                },
                newText: edit.newText,
            });
        }
    }
    return {
        insertText: `<${casing === types_1.TagNameCasing.Kebab ? (0, shared_1.hyphenate)(newName) : newName}$0 />`,
        insertTextFormat: 2,
        additionalEdits: edits,
    };
}
exports.getDragImportEdits = getDragImportEdits;
//# sourceMappingURL=dragImport.js.map