import { ISetBreakpointResult, BreakOnLoadStrategy } from '../debugAdapterInterfaces';
import { Protocol as Crdp } from 'devtools-protocol';
import { ChromeDebugAdapter } from './chromeDebugAdapter';
import { InternalSourceBreakpoint } from './internalSourceBreakpoint';
import { Version } from '..';
export interface UrlRegexAndFileSet {
    urlRegex: string;
    fileSet: Set<string>;
}
export declare class BreakOnLoadHelper {
    private _doesDOMInstrumentationRecieveExtraEvent;
    private _instrumentationBreakpointSet;
    private _stopOnEntryBreakpointIdToRequestedFileName;
    private _stopOnEntryRequestedFileNameToBreakpointId;
    private _stopOnEntryRegexToBreakpointId;
    private _chromeDebugAdapter;
    private _breakOnLoadStrategy;
    constructor(chromeDebugAdapter: ChromeDebugAdapter, breakOnLoadStrategy: BreakOnLoadStrategy);
    validateStrategy(breakOnLoadStrategy: BreakOnLoadStrategy): void;
    readonly stopOnEntryRequestedFileNameToBreakpointId: Map<string, string>;
    readonly stopOnEntryBreakpointIdToRequestedFileName: Map<string, UrlRegexAndFileSet>;
    private readonly instrumentationBreakpointSet;
    private getScriptUrlFromId(scriptId);
    setBrowserVersion(version: Version): Promise<void>;
    /**
     * Handles the onpaused event.
     * Checks if the event is caused by a stopOnEntry breakpoint of using the regex approach, or the paused event due to the Chrome's instrument approach
     * Returns whether we should continue or not on this paused event
     */
    handleOnPaused(notification: Crdp.Debugger.PausedEvent): Promise<boolean>;
    private isInstrumentationPause(notification);
    /**
     * Returns whether we should continue on hitting a stopOnEntry breakpoint
     * Only used when using regex approach for break on load
     */
    private shouldContinueOnStopOnEntryBreakpoint(pausedLocation);
    /**
     * Handles a script with a stop on entry breakpoint and returns whether we should continue or not on hitting that breakpoint
     * Only used when using regex approach for break on load
     */
    private handleStopOnEntryBreakpointAndContinue(notification);
    /**
     * Adds a stopOnEntry breakpoint for the given script url
     * Only used when using regex approach for break on load
     */
    private addStopOnEntryBreakpoint(url);
    /**
     * Handles the AddBreakpoints request when break on load is active
     * Takes the action based on the strategy
     */
    handleAddBreakpoints(url: string, breakpoints: InternalSourceBreakpoint[]): Promise<ISetBreakpointResult[]>;
    /**
     * Tells Chrome to set instrumentation breakpoint to stop on all the scripts before execution
     * Only used when using instrument approach for break on load
     */
    private setInstrumentationBreakpoint();
    private setStopOnEntryBreakpoint(urlRegex);
    private removeBreakpointById(breakpointId);
    /**
     * Checks if we need to call resolvePendingBPs on scriptParsed event
     * If break on load is active and we are using the regex approach, only call the resolvePendingBreakpoint function for files where we do not
     * set break on load breakpoints. For those files, it is called from onPaused function.
     * For the default Chrome's API approach, we don't need to call resolvePendingBPs from inside scriptParsed
     */
    shouldResolvePendingBPs(mappedUrl: string): boolean;
}
