/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.binding.SimpleValueBinding;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.naming.IDsfNamingFamily;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.dom.AttributeMap;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DErrUtil;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNodeList;
import org.eclipse.vjet.dsf.dom.DomUtil;
import org.eclipse.vjet.dsf.dom.GetElementByNSQuery;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.support.DsfDomLevelNotSupportedException;
import org.eclipse.vjet.dsf.dom.support.DsfDomNotSupportedRuntimeException;
import org.eclipse.vjet.dsf.dom.support.NSNameVerifier;
import org.eclipse.vjet.dsf.dom.support.XmlVerifier;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class DElement
extends DNode
implements Element {
    private static final long serialVersionUID = 1L;
    protected AttributeMap m_attributes;

    public DElement(String unqualifiedName) {
        this((DDocument)null, unqualifiedName);
    }

    public DElement(String namespaceUri, String possibleQualifiedName) {
        this(DomUtil.getNamespace(namespaceUri, possibleQualifiedName), DomUtil.getUnqualifedName(possibleQualifiedName));
    }

    public DElement(DNamespace namespace, String unqualifiedName) {
        this(null, namespace, unqualifiedName);
    }

    public DElement(DDocument document, String unqualifiedName) {
        super(document, unqualifiedName);
        if (DsfVerifierConfig.getInstance().isVerifyNaming() && !XmlVerifier.isXMLName(unqualifiedName, this.isDsfXml11Version())) {
            DErrUtil.elementCharError(unqualifiedName, null, null);
        }
    }

    @Override
    public String getTagName() {
        return this.m_nodeName;
    }

    public String getAttribute(Enum<?> attrEnum) {
        if (attrEnum == null) {
            DElement.chuck("Attr enum must not be null");
        }
        return this.getAttribute(attrEnum.name());
    }

    @Override
    public String getAttribute(String name) {
        if (name == null) {
            DElement.chuck("Attribute name must not be null");
        }
        if (this.m_attributes == null) {
            return "";
        }
        DAttr attr = this.m_attributes.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public DElement setDsfAttribute(String name, String value) throws DOMException {
        this.setAttribute(name, value);
        return this;
    }

    public DElement setDsfAttribute(String name, boolean value) throws DOMException {
        this.setAttribute(name, Boolean.toString(value));
        return this;
    }

    public DElement setDsfAttribute(String name, int value) throws DOMException {
        this.setAttribute(name, Integer.toString(value));
        return this;
    }

    public DElement setDsfAttribute(String name, long value) throws DOMException {
        this.setAttribute(name, Long.toString(value));
        return this;
    }

    public DElement setDsfAttribute(String name, double value) throws DOMException {
        this.setAttribute(name, Double.toString(value));
        return this;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        if (name == null) {
            throw new DsfRuntimeException("Attribute name must not be null");
        }
        DAttr attr = this.getDsfAttributes().getAttr(name);
        if (attr == null) {
            attr = new DAttr(name, value);
            this.m_attributes.put(attr);
        }
        attr.setValue(value);
    }

    public DElement setDsfAttribute(Enum<?> attrEnum, String value) throws DOMException {
        this.setAttribute(attrEnum, value);
        return this;
    }

    public DElement setDsfAttribute(Enum<?> attrNameEnum, Enum<?> attrValueEnum) throws DOMException {
        this.setAttribute(attrNameEnum, attrValueEnum.name());
        return this;
    }

    public DElement setDsfAttribute(String name, Enum<?> attrValueEnum) throws DOMException {
        if (attrValueEnum == null) {
            DElement.chuck("Attr value enum must not be null");
        }
        this.setAttribute(name, attrValueEnum.name());
        return this;
    }

    public void setAttribute(Enum<?> attrEnum, String value) throws DOMException {
        if (attrEnum == null) {
            DElement.chuck("Attr name enum must not be null");
        }
        this.setAttribute(attrEnum.name(), value);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        if (name == null) {
            throw new DsfRuntimeException("attribute name must not be null");
        }
        PropertyDescriptor pd = this.getPropertyDescriptor(name);
        if (pd != null) {
            throw new DsfRuntimeException("Can not remove an intrinsic property");
        }
        if (this.m_attributes == null) {
            return;
        }
        this.m_attributes.remove(name);
    }

    public void removeAttribute(Enum<?> attrEnum) throws DOMException {
        if (attrEnum == null) {
            DElement.chuck("Attr enum must not be null");
        }
        this.removeAttribute(attrEnum.name());
    }

    @Override
    public Attr getAttributeNode(String name) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.getAttributeNode(name);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            throw new DsfRuntimeException("null attribute not allowed");
        }
        DAttr existing = this.getDsfAttributes().getAttr(newAttr.getName());
        DAttr attr = (DAttr)newAttr;
        attr.setOwnerElement(this);
        this.m_attributes.put(attr);
        if (existing != null) {
            existing.setOwnerElement(null);
        }
        return existing;
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr == null) {
            throw new DOMException(8, "null attribute node is not valid and cannot be found");
        }
        if (this.m_attributes == null) {
            return null;
        }
        return (Attr)this.m_attributes.removeNamedItem(oldAttr.getName());
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        DNodeList answer = new DNodeList(this, 5);
        this.getElementsByTagName(name, answer);
        return answer;
    }

    protected void getElementsByTagName(String name, DNodeList answer) {
        boolean matchesAll = "*".equals(name);
        if (this.m_childNodes == null) {
            return;
        }
        int size = this.m_childNodes.size();
        int i = 0;
        while (i < size) {
            DNode childx = (DNode)this.m_childNodes.get(i);
            if (childx instanceof DElement) {
                DElement child = (DElement)childx;
                String childName = child.getNodeName();
                if (matchesAll || childName.equals(name)) {
                    answer.privateAdd(child);
                }
                child.getElementsByTagName(name, answer);
            }
            ++i;
        }
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("getAttributeNS(...)");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("setAttributeNS(...)");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("removeAttributeNS(...)");
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("getAttributeNodeNS(...)");
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("setAttributeNodeNS(...)");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        DNodeList answer = new DNodeList(this, 5);
        this.getElementByTagNameNS(localName, namespaceURI, answer);
        return answer;
    }

    public NodeList dsfGetElementsByTagNameNS(DNamespace namespace, String localName) throws DOMException {
        DNodeList answer = new DNodeList(this, 5);
        this.getElementByTagNameNS(localName, namespace, answer);
        return answer;
    }

    private void getElementByTagNameNS(String name, String nsUri, DNodeList answer) {
        if (this.m_childNodes == null) {
            return;
        }
        if (nsUri == null) {
            this.getElementsByTagName(name, answer);
            return;
        }
        if (name == null) {
            return;
        }
        boolean matchesAllName = "*".equals(name);
        boolean matchesAllUri = "*".equals(nsUri);
        for (DNode childx : this.m_childNodes) {
            if (childx.getNodeType() != 1) continue;
            if (matchesAllName) {
                if (matchesAllUri) {
                    answer.privateAdd(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.privateAdd(childx);
                }
            } else if (childx.getLocalName() != null && childx.getLocalName().equals(name)) {
                if (matchesAllUri) {
                    answer.privateAdd(childx);
                } else if (nsUri.equals(childx.getNamespaceURI())) {
                    answer.privateAdd(childx);
                }
            }
            ((DElement)childx).getElementByTagNameNS(name, nsUri, answer);
        }
    }

    private void getElementByTagNameNS(String name, DNamespace ns, DNodeList answer) {
        if (this.m_childNodes == null) {
            return;
        }
        if (ns == null) {
            this.getElementsByTagName(name, answer);
            return;
        }
        if (name == null) {
            return;
        }
        boolean matchesAllName = "*".equals(name);
        for (DNode childx : this.m_childNodes) {
            if (childx.getNodeType() != 1) continue;
            if (matchesAllName && ns == childx.getDsfNamespace()) {
                answer.privateAdd(childx);
            } else if (childx.getLocalName() != null && childx.getLocalName().equals(name) && ns == childx.getDsfNamespace()) {
                answer.privateAdd(childx);
            }
            ((DElement)childx).getElementByTagNameNS(name, ns, answer);
        }
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName, IDNodeHandlingStrategy traversal) throws DOMException {
        DNodeList answer = new DNodeList(this, 5);
        GetElementByNSQuery qry = new GetElementByNSQuery(answer, namespaceURI, localName);
        qry.setStrategy(traversal);
        this.dsfAccept(qry);
        return answer;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            DElement.chuck("Attribute name must not be null");
        }
        if (this.m_attributes == null) {
            return false;
        }
        return this.m_attributes.containsKey(name);
    }

    public boolean hasAttribute(Enum<?> attrEnum) {
        if (attrEnum == null) {
            DElement.chuck("Attr enum must not be null");
        }
        return this.hasAttribute(attrEnum.name());
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("hasAttributeNS(...)");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        if (name == null) {
            throw new DOMException(8, "attribute with null name");
        }
        if (this.m_attributes == null) {
            throw new DOMException(8, "no attribute found with name " + name);
        }
        DAttr attr = this.getDsfAttributes().getAttr(name);
        if (attr == null) {
            throw new DOMException(8, "no attribute found with name " + name);
        }
        String id = attr.getNodeValue();
        if (this.getDsfOwnerDocument() != null) {
            if (isId) {
                this.getDsfOwnerDocument().putIdentifier(id, this);
            } else {
                this.getDsfOwnerDocument().removeIdentifier(id);
            }
        }
        attr.setId(isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DsfDomLevelNotSupportedException(3);
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean isId) throws DOMException {
        if (attr.getOwnerElement() != this) {
            throw new DOMException(8, "An attempt is made to reference a node in a context where it does not exist.");
        }
        DAttr idAttr = (DAttr)attr;
        if (idAttr.isId() == isId) {
            return;
        }
        String id = idAttr.getNodeValue();
        if (isId) {
            this.getDsfOwnerDocument().putIdentifier(id, this);
        } else {
            this.getDsfOwnerDocument().removeIdentifier(id);
        }
        idAttr.setId(isId);
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public DElement add(DNode node) {
        super.add(node);
        return this;
    }

    @Override
    public DElement add(String text) {
        super.add(text);
        return this;
    }

    @Override
    public DElement addRaw(String text) {
        super.addRaw(text);
        return this;
    }

    @Override
    public DElement dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    @Override
    public DElement dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    @Override
    public DElement setDsfExportingLocalNames(boolean export) {
        super.setDsfExportingLocalNames(export);
        return this;
    }

    @Override
    public DElement setDsfNamingFamily(IDsfNamingFamily family) {
        super.setDsfNamingFamily(family);
        return this;
    }

    @Override
    public DElement setDsfRelationshipVerifier(IDNodeRelationshipVerifier verifier) {
        super.setDsfRelationshipVerifier(verifier);
        return this;
    }

    @Override
    public DElement dsfDiscard() {
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_attributes = null;
        super.dsfDiscard();
        return this;
    }

    @Override
    public DElement cloneInternal(boolean deep) throws CloneNotSupportedException {
        DElement copy = (DElement)super.cloneInternal(deep);
        if (this.m_attributes == null) {
            return copy;
        }
        copy.m_attributes = this.createAttributeMap(this.m_attributes.size());
        for (Map.Entry<String, DAttr> entry : this.m_attributes.attrEntrySet()) {
            DAttr attr = entry.getValue();
            copy.m_attributes.put(attr.getNodeName(), (Object)attr.getNodeValue());
            IValueBinding<Object> binding = attr.getValueBinding();
            if (binding == null) continue;
            SimpleValueBinding<Object> newBinding = new SimpleValueBinding<Object>(Object.class, binding.getValue());
            copy.m_attributes.setValueBinding(entry.getKey(), newBinding);
        }
        return copy;
    }

    @Override
    public DElement jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        Z z = new Z();
        z.format("element attrs", (Object)this.getElementAttrs());
        return String.valueOf(super.toString()) + z.toString();
    }

    private String getElementAttrs() {
        String answer = "{ ";
        if (this.m_attributes != null) {
            Set<Map.Entry<String, DAttr>> entries = this.m_attributes.attrEntrySet();
            Iterator<Map.Entry<String, DAttr>> itr = entries.iterator();
            while (itr.hasNext()) {
                Map.Entry<String, DAttr> entry = itr.next();
                String attrName = entry.getKey();
                DAttr attr = entry.getValue();
                String x = "{" + attrName + ", " + attr.getValue() + "}";
                if (itr.hasNext()) {
                    x = String.valueOf(x) + ", ";
                }
                answer = String.valueOf(answer) + x;
            }
        }
        answer = String.valueOf(answer) + " }";
        return answer;
    }

    protected boolean toBoolean(String name, String value) {
        return name.equals(value);
    }

    protected int toInt(String label, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DsfRuntimeException("Unable to convert " + label + " value: " + value + " to int", (Throwable)e);
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.m_attributes == null) {
            this.m_attributes = this.createAttributeMap(4);
        }
        return this.m_attributes;
    }

    public NamedNodeMap getAttributes(int initialSize) {
        if (this.m_attributes == null) {
            if (initialSize < 0) {
                DElement.chuck("The initialSize must not be negative");
            }
            this.createAttributeMap(initialSize);
        }
        return this.m_attributes;
    }

    @Override
    public boolean hasAttributes() {
        if (this.m_attributes == null) {
            return false;
        }
        return !this.m_attributes.isEmpty();
    }

    @Override
    public IAttributeMap getDsfAttributes() {
        return (IAttributeMap)((Object)this.getAttributes());
    }

    public IAttributeMap getDsfAttributes(int initialSize) {
        return (IAttributeMap)((Object)this.getAttributes(initialSize));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DElement copy = this.cloneInternal(true);
        return copy;
    }

    protected AttributeMap createAttributeMap(int initialSize) {
        return new AttributeMap(this, this, initialSize);
    }

    @Override
    public String getPrefix() {
        return this.m_prefix;
    }

    @Override
    public String getNamespaceURI() {
        return this.m_dsfNamespace != null ? this.m_dsfNamespace.getNamespaceKey() : null;
    }

    @Override
    protected boolean isEqualAttrs(Node arg) {
        if (this.hasAttributes() != arg.hasAttributes()) {
            return false;
        }
        if (!this.hasAttributes()) {
            return true;
        }
        NamedNodeMap map1 = this.getAttributes();
        NamedNodeMap map2 = arg.getAttributes();
        int len = map1.getLength();
        if (len != map2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            Node n2;
            Node n1 = map1.item(i);
            if (n1.getLocalName() == null ? (n2 = map2.getNamedItem(n1.getNodeName())) == null || !n1.isEqualNode(n2) : (n2 = map2.getNamedItemNS(n1.getNamespaceURI(), n1.getLocalName())) == null || !n1.isEqualNode(n2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    DElement(DDocument document, String namespaceURI, String tagName) {
        this(document, tagName);
        this.setNamespace(namespaceURI, tagName);
    }

    public DElement(DDocument document, DNamespace namespace, String localName) {
        this(document, localName);
        if (DsfVerifierConfig.getInstance().isVerifyNaming()) {
            NSNameVerifier.verifyNSLocalName(this.m_nodeName, null);
        }
        this.setDsfNamespace(namespace);
    }

    private void setNamespace(String namespaceURI, String tagName) {
        int colon1 = this.m_nodeName.indexOf(":");
        int colon2 = this.m_nodeName.lastIndexOf(":");
        if (DsfVerifierConfig.getInstance().isVerifyNaming() && (colon1 == 0 || colon1 == this.m_nodeName.length() - 1 || colon2 != colon1)) {
            DErrUtil.elementNSError(this.m_nodeName, null, null);
        }
        if (colon1 < 0) {
            if (DsfVerifierConfig.getInstance().isVerifyNaming()) {
                NSNameVerifier.verifyNSLocalName(this.m_nodeName, namespaceURI);
            }
            if (namespaceURI != null) {
                this.setNamespaceInternal(DNamespace.getNamespace(null, namespaceURI), false);
            }
        } else {
            String prefix = this.m_nodeName.substring(0, colon1);
            this.m_localName = this.m_nodeName.substring(colon2 + 1);
            this.setNamespaceInternal(DNamespace.getNamespace(prefix, namespaceURI), false);
        }
    }

    @Override
    public String getLocalName() {
        return this.m_localName;
    }

    @Override
    public String getBaseURI() {
        DNamespace ns = this.m_ownerDocument != null ? this.m_ownerDocument.getDsfDocumentURI() : null;
        return ns == null ? null : ns.getNamespaceKey();
    }

    @Override
    public DNamespace getDsfBaseURI() {
        DNode rootN = this.getRootElement();
        if (rootN != null && rootN.getDsfNamespace() != null) {
            return rootN.getDsfNamespace();
        }
        return this.m_ownerDocument != null ? this.m_ownerDocument.getDsfDocumentURI() : null;
    }

    @Override
    public DElement setDsfNamespace(DNamespace namespace) {
        return this.setNamespaceInternal(namespace, true);
    }

    private DElement setNamespaceInternal(DNamespace namespace, boolean bNoneNSPrefixReset) {
        if (namespace == null) {
            if (this.m_dsfNamespace == null) {
                return this;
            }
            this.m_prefix = null;
            this.m_nodeName = this.m_localName;
            this.m_dsfNamespace = null;
            return this;
        }
        if (this.m_dsfNamespace == null) {
            this.m_prefix = namespace.getPrefix();
            if (bNoneNSPrefixReset && this.m_prefix != null) {
                this.m_localName = this.m_nodeName;
                this.m_nodeName = String.valueOf(this.m_prefix) + ":" + this.m_localName;
            }
        } else {
            if (this.m_prefix == null) {
                this.m_localName = this.m_nodeName;
            }
            this.m_prefix = namespace.getPrefix();
            this.m_nodeName = this.m_prefix != null ? String.valueOf(this.m_prefix) + ":" + this.m_localName : this.m_localName;
        }
        this.m_dsfNamespace = namespace;
        return this;
    }

    @Override
    public DNamespace getDsfNamespace() {
        return this.m_dsfNamespace;
    }

    protected <T extends Class> Node getOrCreate(T clz, int count) {
        if (count <= 0) {
            return this.create(clz);
        }
        int found = 0;
        if (this.hasChildNodes()) {
            NodeList kids = this.getChildNodes();
            int len = kids.getLength();
            int i = 0;
            while (i < len) {
                Node node = kids.item(i);
                if (node.getClass() == clz && ++found == count) {
                    return node;
                }
                ++i;
            }
        }
        int numOfNodesToCreate = count - found;
        int i = 1;
        while (i <= numOfNodesToCreate) {
            Node node = this.create(clz);
            if (i == numOfNodesToCreate) {
                return node;
            }
            ++i;
        }
        throw new RuntimeException("Create node logic failed");
    }

    private Node create(Class<?> clz) {
        try {
            Node node = (Node)clz.newInstance();
            this.appendChild(node);
            return node;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends Class> Node getOrCreate(T clz) {
        if (this.hasChildNodes()) {
            NodeList kids = this.getChildNodes();
            int len = kids.getLength();
            int i = 0;
            while (i < len) {
                Node node = kids.item(i);
                if (node.getClass() == clz) {
                    return node;
                }
                ++i;
            }
        }
        return this.create(clz);
    }
}

