/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.DSFRootAnchor;
import org.eclipse.vjet.dsf.common.trace.IInstrumentDElement;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.w3c.dom.Node;

public class HtmlTraceInstrumenter
implements IInstrumentDElement {
    private Map<String, Integer> m_traceback = new HashMap<String, Integer>();

    public HtmlTraceInstrumenter(Map htmlTraceMap) {
        this.m_traceback = htmlTraceMap;
    }

    @Override
    public void appendElement(Node parent, Node node) {
        if (node.getClass().getName().startsWith(DSFRootAnchor.class.getPackage().getName())) {
            if (node.getNodeType() != 1) {
                return;
            }
            if (node.getClass().getName().equals("org.eclipse.vjet.dsf.resource.content.runtime.DContent")) {
                return;
            }
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            for (int caller = trace.length - 1; caller >= 0; --caller) {
                if (!trace[caller].getMethodName().startsWith("appendChild") && !trace[caller].getMethodName().startsWith("add")) {
                    continue;
                }
                StringBuffer spyTr = new StringBuffer();
                String key = null;
                int traceCount = 0;
                int i = caller + 1;
                while (i < trace.length) {
                    if (++traceCount > 15) break;
                    key = String.valueOf(trace[i].getClassName()) + ":" + trace[i].getMethodName() + ":" + trace[i].getLineNumber();
                    if (this.m_traceback.containsKey(key)) {
                        spyTr.append(this.m_traceback.get(key).toString());
                    } else {
                        this.m_traceback.put(key, new Integer(this.m_traceback.size()));
                        spyTr.append(this.m_traceback.get(key).toString());
                    }
                    if (i < trace.length - 1) {
                        spyTr.append(" ");
                    }
                    ++i;
                }
                DElement de = (DElement)node;
                de.setAttribute("spyTr", spyTr.toString());
                return;
            }
        }
    }

    @Override
    public void setAttributeValue(DElement node, DAttr attr, String value) {
    }

    @Override
    public void endElement(DElement node, IXmlStreamWriter writer) {
    }

    @Override
    public void endSelfRender(DElement node, IXmlStreamWriter writer) {
    }

    @Override
    public void startElement(DElement node, IXmlStreamWriter writer) {
    }

    @Override
    public void startSelfRender(DElement node, IXmlStreamWriter writer) {
    }
}

