/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.map.ListOrderedMap;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.ConsoleTraceWriter;
import org.eclipse.vjet.dsf.common.trace.IDsfTracer;
import org.eclipse.vjet.dsf.common.trace.ITraceWriter;
import org.eclipse.vjet.dsf.common.trace.TraceConfig;
import org.eclipse.vjet.dsf.common.xml.XmlEncoder;

public class DefaultTracer
implements IDsfTracer {
    private List<ITraceWriter> m_writers = new ArrayList<ITraceWriter>(1);
    private int m_traceDepth = -1;
    private boolean m_traceEnabled = false;
    private ListOrderedMap m_stackLabels = new ListOrderedMap();
    private static final String DOT = ".";

    public DefaultTracer() {
        this.reset();
    }

    public void enableTrace(boolean enable) {
        this.m_traceEnabled = enable;
    }

    public boolean isEnabled() {
        return this.m_traceEnabled;
    }

    public IDsfTracer addWriter(ITraceWriter handler) {
        if (handler == null) {
            DsfExceptionHelper.chuck((String)"handler is null");
        }
        this.m_writers.add(handler);
        return this;
    }

    public void enterMethod(Object caller) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.push(String.valueOf(clsName) + DOT + methodName);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleEnterMethod(DefaultTracer.this.m_traceDepth, clsName, methodName);
            }
        });
    }

    public void enterMethod(Object caller, final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.push(String.valueOf(clsName) + DOT + methodName);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleEnterMethod(DefaultTracer.this.m_traceDepth, clsName, methodName, msg);
            }
        });
    }

    public void exitMethod(Object caller) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleExitMethod(DefaultTracer.this.m_traceDepth, clsName, methodName);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + methodName);
    }

    public void exitMethod(Object caller, final IDsfTracer.ExitStatus status) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleExitMethod(DefaultTracer.this.m_traceDepth, clsName, methodName, status);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + methodName);
    }

    public void exitMethod(Object caller, final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleExitMethod(DefaultTracer.this.m_traceDepth, clsName, methodName, msg);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + methodName);
    }

    public void exitMethod(Object caller, final IDsfTracer.ExitStatus status, final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (caller == null) {
            return;
        }
        Throwable t = new Throwable();
        t.fillInStackTrace();
        final String clsName = this.getClassName(caller);
        final String methodName = this.getMethodName(caller, t);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleExitMethod(DefaultTracer.this.m_traceDepth, clsName, methodName, status, msg);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + methodName);
    }

    public void startCall(Object callee, final String method) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (callee == null) {
            return;
        }
        final String clsName = callee.getClass().getName();
        this.push(String.valueOf(clsName) + DOT + method);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleStartCall(DefaultTracer.this.m_traceDepth, clsName, method);
            }
        });
    }

    public void startCall(Object callee, final String method, final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (callee == null) {
            return;
        }
        final String clsName = callee.getClass().getName();
        this.push(String.valueOf(clsName) + DOT + method);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleStartCall(DefaultTracer.this.m_traceDepth, clsName, method, msg);
            }
        });
    }

    public void endCall(Object callee, final String method, final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (callee == null) {
            return;
        }
        final String clsName = callee.getClass().getName();
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleEndCall(DefaultTracer.this.m_traceDepth, clsName, method, msg);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + method);
    }

    public void endCall(Object callee, final String method) {
        if (!this.m_traceEnabled) {
            return;
        }
        if (callee == null) {
            return;
        }
        final String clsName = callee.getClass().getName();
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleEndCall(DefaultTracer.this.m_traceDepth, clsName, method);
            }
        });
        this.pop(String.valueOf(clsName) + DOT + method);
    }

    public void startLoop(final String group) {
        if (!this.m_traceEnabled) {
            return;
        }
        this.push(group);
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleStartLoop(DefaultTracer.this.m_traceDepth, group);
            }
        });
    }

    public void loopStep(final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleLoopStep(DefaultTracer.this.m_traceDepth, msg);
            }
        });
    }

    public void endLoop(final String group) {
        if (!this.m_traceEnabled) {
            return;
        }
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleEndLoop(DefaultTracer.this.m_traceDepth, group);
            }
        });
        this.pop(group);
    }

    public void msg(final String msg) {
        if (!this.m_traceEnabled) {
            return;
        }
        this.dispatch(new WriterInvoker(){

            @Override
            public void process(ITraceWriter w) {
                w.handleMsg(DefaultTracer.this.m_traceDepth, msg);
            }
        });
    }

    public void reset() {
        this.m_traceDepth = -1;
        this.m_writers.clear();
        TraceConfig cfg = TraceConfig.getInstance();
        this.m_writers = new ArrayList<ITraceWriter>(cfg.getWriters());
        this.m_traceEnabled = cfg.isEnabled();
        if (this.m_traceEnabled && this.m_writers.size() == 0) {
            this.m_writers.add(new ConsoleTraceWriter());
        }
    }

    private String getClassName(Object caller) {
        String name = caller.getClass().getName();
        int start = name.lastIndexOf(46);
        if (start != -1) {
            name = name.substring(start + 1);
        }
        return name;
    }

    private String getMethodName(Object caller, Throwable t) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(stream));
        Class<?> cls = caller.getClass();
        String clsName = cls.getName();
        String stackTrace = stream.toString();
        int index = stackTrace.indexOf(clsName);
        while (index < 1) {
            if ((cls = cls.getSuperclass()) == null) {
                return "NotFound";
            }
            clsName = cls.getName();
            index = stackTrace.indexOf(clsName);
        }
        int start = stackTrace.indexOf(clsName) + clsName.length() + 1;
        int end = stackTrace.indexOf("(", start);
        return XmlEncoder.encode((String)stackTrace.substring(start, end));
    }

    private void push(String label) {
        if (label == null || label.trim().length() == 0) {
            DsfExceptionHelper.chuck((String)"label is null");
        }
        ++this.m_traceDepth;
        this.m_stackLabels.put((Object)this.m_traceDepth, (Object)label);
    }

    private void pop(String label) {
        if (this.m_stackLabels.get(this.m_stackLabels.lastKey()).equals(label)) {
            --this.m_traceDepth;
            this.m_stackLabels.remove(this.m_stackLabels.lastKey());
        } else if (this.m_traceDepth > 0) {
            --this.m_traceDepth;
            this.m_stackLabels.remove(this.m_stackLabels.lastKey());
            this.pop(label);
        }
    }

    private void dispatch(WriterInvoker wi) {
        for (ITraceWriter w : this.m_writers) {
            wi.process(w);
        }
    }

    static interface WriterInvoker {
        public void process(ITraceWriter var1);
    }
}

